/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.text.OrdinalFormat;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BundleBase {
    public static final char MNEMONIC = '\u001b';
    public static final String MNEMONIC_STRING = Character.toString('\u001b');
    private static final String L10N_MARKER = "\ud83d\udd05";
    public static final boolean SHOW_LOCALIZED_MESSAGES = Boolean.getBoolean("idea.l10n");
    private static final Logger LOG = Logger.getInstance(BundleBase.class);
    private static boolean assertOnMissedKeys;
    private static final String[] SUFFIXES;

    public static void assertOnMissedKeys(boolean doAssert) {
        assertOnMissedKeys = doAssert;
    }

    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return BundleBase.messageOrDefault(bundle, key, null, params);
    }

    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        String value;
        if (bundle == null) {
            return defaultValue;
        }
        boolean resourceFound = true;
        try {
            value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            resourceFound = false;
            value = BundleBase.useDefaultValue(bundle, key, defaultValue);
        }
        String result = BundleBase.postprocessValue(bundle, value, params);
        if (SHOW_LOCALIZED_MESSAGES && resourceFound) {
            return BundleBase.appendLocalizationMarker(result);
        }
        return result;
    }

    @NotNull
    protected static String appendLocalizationMarker(@NotNull String result) {
        for (String suffix : SUFFIXES) {
            if (!result.endsWith(suffix)) continue;
            return result.substring(0, result.length() - suffix.length()) + L10N_MARKER + suffix;
        }
        return result + L10N_MARKER;
    }

    @NotNull
    static String useDefaultValue(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue) {
        if (defaultValue != null) {
            return defaultValue;
        }
        if (assertOnMissedKeys) {
            LOG.error("'" + key + "' is not found in " + bundle);
        }
        return "!" + key + "!";
    }

    @NotNull
    static String postprocessValue(@NotNull ResourceBundle bundle, @NotNull String value, Object ... params) {
        value = BundleBase.replaceMnemonicAmpersand(value);
        if (params.length > 0 && value.indexOf(123) >= 0) {
            Locale locale = bundle.getLocale();
            try {
                MessageFormat format = locale != null ? new MessageFormat(value, locale) : new MessageFormat(value);
                OrdinalFormat.apply(format);
                value = format.format(params);
            }
            catch (IllegalArgumentException e) {
                value = "!invalid format: `" + value + "`!";
            }
        }
        return value;
    }

    @NotNull
    public static String format(@NotNull String value, Object ... params) {
        return params.length > 0 && value.indexOf(123) >= 0 ? MessageFormat.format(value, params) : value;
    }

    @Contract(value="null -> null; !null -> !null")
    public static String replaceMnemonicAmpersand(@Nullable String value) {
        if (value == null || value.indexOf(38) < 0) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        boolean macMnemonic = value.contains("&&");
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    builder.append('&');
                    ++i;
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '&') {
                if (i < value.length() - 1 && value.charAt(i + 1) == '&') {
                    if (SystemInfoRt.isMac) {
                        builder.append('\u001b');
                    }
                    ++i;
                    continue;
                }
                if (SystemInfoRt.isMac && macMnemonic) continue;
                builder.append('\u001b');
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    static {
        SUFFIXES = new String[]{"</body></html>", "</html>"};
    }
}

