/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.BundleBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBundle {
    private static final Logger LOG = Logger.getInstance(AbstractBundle.class);
    private Reference<ResourceBundle> myBundle;
    @NonNls
    private final String myPathToBundle;
    private static final Map<ClassLoader, Map<String, ResourceBundle>> ourCache = ConcurrentFactoryMap.createWeakMap(k -> ContainerUtil.createConcurrentSoftValueMap());

    protected AbstractBundle(@NonNls @NotNull String pathToBundle) {
        this.myPathToBundle = pathToBundle;
    }

    @NotNull
    public String getMessage(@NotNull String key, Object ... params) {
        return AbstractBundle.message(this.getResourceBundle(), key, params);
    }

    @NotNull
    public Supplier<String> getLazyMessage(@NotNull String key, Object ... params) {
        return () -> this.getMessage(key, params);
    }

    @Nullable
    public String messageOfNull(@NotNull String key, Object ... params) {
        return AbstractBundle.messageOrNull(this.getResourceBundle(), key, params);
    }

    public String messageOrDefault(@NotNull String key, @Nullable String defaultValue, Object ... params) {
        return AbstractBundle.messageOrDefault(this.getResourceBundle(), key, defaultValue, params);
    }

    @Contract(value="null, _, _, _ -> param3")
    public static String messageOrDefault(@Nullable ResourceBundle bundle, @NotNull String key, @Nullable String defaultValue, Object ... params) {
        if (bundle == null) {
            return defaultValue;
        }
        if (!bundle.containsKey(key)) {
            return BundleBase.postprocessValue(bundle, BundleBase.useDefaultValue(bundle, key, defaultValue), params);
        }
        return BundleBase.messageOrDefault(bundle, key, defaultValue, params);
    }

    @Nls
    @NotNull
    public static String message(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        return BundleBase.message(bundle, key, params);
    }

    @Nullable
    public static String messageOrNull(@NotNull ResourceBundle bundle, @NotNull String key, Object ... params) {
        String value = AbstractBundle.messageOrDefault(bundle, key, key, params);
        if (key.equals(value)) {
            return null;
        }
        return value;
    }

    public boolean containsKey(@NotNull String key) {
        return this.getResourceBundle().containsKey(key);
    }

    public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(null);
    }

    @ApiStatus.Internal
    @NotNull
    protected ResourceBundle getResourceBundle(@Nullable ClassLoader classLoader) {
        ResourceBundle bundle = SoftReference.dereference(this.myBundle);
        if (bundle == null) {
            bundle = this.getResourceBundle(this.myPathToBundle, classLoader == null ? this.getClass().getClassLoader() : classLoader);
            this.myBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    @NotNull
    public ResourceBundle getResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        Map<String, ResourceBundle> map = ourCache.get(loader);
        ResourceBundle result = map.get(pathToBundle);
        if (result == null) {
            try {
                ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
                result = this.findBundle(pathToBundle, loader, control);
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
                ResourceBundle.clearCache(loader);
                result = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            }
            map.put(pathToBundle, result);
        }
        return result;
    }

    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader, @NotNull ResourceBundle.Control control) {
        return ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
    }
}

