/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.dvcs.ui.DvcsStatusWidget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.branch.HgBranchPopup;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgStatusWidget
extends DvcsStatusWidget<HgRepository> {
    private static final String ID = "hg";
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings myProjectSettings;

    public HgStatusWidget(@NotNull HgVcs vcs, @NotNull Project project, @NotNull HgProjectSettings projectSettings) {
        super(project, vcs.getShortName());
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
        project.getMessageBus().connect((Disposable)this).subscribe(HgVcs.STATUS_TOPIC, (p, root) -> this.updateLater());
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public StatusBarWidget copy() {
        return new HgStatusWidget(this.myVcs, this.myProject, this.myProjectSettings);
    }

    @Nullable
    protected HgRepository guessCurrentRepository(@NotNull Project project) {
        return (HgRepository)DvcsUtil.guessCurrentRepositoryQuick((Project)project, (AbstractRepositoryManager)HgUtil.getRepositoryManager(project), (String)HgProjectSettings.getInstance(project).getRecentRootPath());
    }

    @NotNull
    protected String getFullBranchName(@NotNull HgRepository repository) {
        return HgUtil.getDisplayableBranchOrBookmarkText(repository);
    }

    protected boolean isMultiRoot(@NotNull Project project) {
        return HgUtil.getRepositoryManager(project).moreThanOneRoot();
    }

    @NotNull
    protected ListPopup getPopup(@NotNull Project project, @NotNull HgRepository repository) {
        return HgBranchPopup.getInstance(project, repository).asListPopup();
    }

    protected void rememberRecentRoot(@NotNull String path) {
        this.myProjectSettings.setRecentRootPath(path);
    }

    public static class Factory
    implements StatusBarWidgetFactory {
        @NotNull
        public String getId() {
            return HgStatusWidget.ID;
        }

        @Nls
        @NotNull
        public String getDisplayName() {
            return HgBundle.message("hg4idea.status.bar.widget.name", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project) {
            return !((HgRepositoryManager)((Object)project.getService(HgRepositoryManager.class))).getRepositories().isEmpty();
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            return new HgStatusWidget(Objects.requireNonNull(HgVcs.getInstance(project)), project, HgProjectSettings.getInstance(project));
        }

        public void disposeWidget(@NotNull StatusBarWidget widget) {
            Disposer.dispose((Disposable)widget);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            return true;
        }
    }

    public static class Listener
    implements VcsRepositoryMappingListener {
        private final Project myProject;

        public Listener(@NotNull Project project) {
            this.myProject = project;
        }

        public void mappingChanged() {
            ((StatusBarWidgetsManager)this.myProject.getService(StatusBarWidgetsManager.class)).updateWidget(Factory.class);
        }
    }
}

