/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.ignore.VcsIgnoredFilesHolderBase;
import com.intellij.dvcs.ignore.VcsRepositoryIgnoredFilesHolder;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsIgnoredFilesHolder;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgIgnoredFileHolder
extends VcsIgnoredFilesHolderBase<HgRepository> {
    private final Project myProject;
    private final HgRepositoryManager myManager;

    public HgIgnoredFileHolder(@NotNull Project project, @NotNull HgRepositoryManager manager) {
        super((AbstractRepositoryManager)manager);
        this.myProject = project;
        this.myManager = manager;
    }

    @NotNull
    protected VcsRepositoryIgnoredFilesHolder getHolder(@NotNull HgRepository repository) {
        return repository.getIgnoredFilesHolder();
    }

    public FileHolder copy() {
        return new HgIgnoredFileHolder(this.myProject, this.myManager);
    }

    public static class Provider
    implements VcsIgnoredFilesHolder.Provider,
    ChangesViewRefresher {
        private final Project myProject;
        private final HgVcs myVcs;
        private final HgRepositoryManager myManager;

        public Provider(Project project) {
            this.myProject = project;
            this.myVcs = HgVcs.getInstance(this.myProject);
            this.myManager = HgUtil.getRepositoryManager(this.myProject);
        }

        @NotNull
        public AbstractVcs getVcs() {
            return this.myVcs;
        }

        @NotNull
        public VcsIgnoredFilesHolder createHolder() {
            return new HgIgnoredFileHolder(this.myProject, this.myManager);
        }

        public void refresh(Project project) {
            this.myManager.getRepositories().forEach(r -> r.getIgnoredFilesHolder().startRescan());
        }
    }
}

