/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgBranchManager;
import org.zmlx.hg4idea.branch.HgBranchType;
import org.zmlx.hg4idea.branch.HgBrancher;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgCommonBranchActions
extends BranchActionGroup {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final HgBranchManager myBranchManager;
    @NotNull
    protected final String myBranchName;
    @NotNull
    protected final List<HgRepository> myRepositories;
    @Nullable
    private final HgBranchType myBranchType;

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
        this(project, repositories, branchName, null);
    }

    HgCommonBranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName, @Nullable HgBranchType branchType) {
        this.myProject = project;
        this.myBranchName = branchName;
        this.myRepositories = repositories;
        this.myBranchManager = (HgBranchManager)((Object)ServiceManager.getService((Project)project, HgBranchManager.class));
        this.getTemplatePresentation().setText(this.myBranchName, false);
        this.myBranchType = branchType;
        this.setFavorite(this.myBranchManager.isFavorite(this.myBranchType, HgCommonBranchActions.chooseRepository(this.myRepositories), this.myBranchName));
        this.hideIconForUnnamedHeads();
    }

    private void hideIconForUnnamedHeads() {
        if (this.myBranchType == null) {
            this.getTemplatePresentation().setIcon(null);
            this.getTemplatePresentation().setHoveredIcon(null);
        }
    }

    @Nullable
    private static HgRepository chooseRepository(@NotNull List<? extends HgRepository> repositories) {
        assert (!repositories.isEmpty());
        return repositories.size() > 1 ? null : repositories.get(0);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        return new AnAction[]{new UpdateAction(this.myProject, this.myRepositories, this.myBranchName), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName)};
    }

    public void toggle() {
        super.toggle();
        this.myBranchManager.setFavorite(this.myBranchType, HgCommonBranchActions.chooseRepository(this.myRepositories), this.myBranchName, this.isFavorite());
    }

    private static class CompareAction
    extends HgBranchAbstractAction {
        CompareAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, HgBundle.message("action.hg4idea.Compare", new Object[0]), repositories, branchName);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            HgRepository repository = (HgRepository)this.myRepositories.get(0);
            new HgBrancher(this.myProject).compare(this.myBranchName, this.myRepositories, repository);
        }
    }

    private static class UpdateAction
    extends HgBranchAbstractAction {
        UpdateAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, HgBundle.message("action.hg4idea.Update", new Object[0]), repositories, branchName);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            HgUpdateCommand.updateTo(this.myBranchName, this.myRepositories, null);
        }
    }

    private static class MergeAction
    extends HgBranchAbstractAction {
        MergeAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            super(project, HgBundle.message("action.hg4idea.Merge", new Object[0]), repositories, branchName);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            UpdatedFiles updatedFiles = UpdatedFiles.create();
            for (HgRepository repository : this.myRepositories) {
                HgMergeCommand.mergeWith(repository, this.myBranchName, updatedFiles);
            }
        }
    }
}

