/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action.mq;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.ui.HgMqUnAppliedPatchesPanel;

public abstract class HgActionFromMqPatches
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        HgMqUnAppliedPatchesPanel patchInfo = (HgMqUnAppliedPatchesPanel)e.getRequiredData(HgMqUnAppliedPatchesPanel.MQ_PATCHES);
        List<String> names = patchInfo.getSelectedPatchNames();
        HgRepository repository = patchInfo.getRepository();
        Runnable task = () -> {
            ProgressManager.getInstance().getProgressIndicator().setText(this.getTitle());
            this.executeInCurrentThread(repository, names);
        };
        patchInfo.updatePatchSeriesInBackground(task);
    }

    public void update(@NotNull AnActionEvent e) {
        HgMqUnAppliedPatchesPanel patchInfo = (HgMqUnAppliedPatchesPanel)e.getData(HgMqUnAppliedPatchesPanel.MQ_PATCHES);
        e.getPresentation().setEnabled(patchInfo != null && patchInfo.getSelectedRowsCount() != 0 && this.isEnabled(patchInfo.getRepository()));
    }

    protected boolean isEnabled(@NotNull HgRepository repository) {
        return true;
    }

    protected abstract void executeInCurrentThread(@NotNull HgRepository var1, @NotNull List<String> var2);

    @NotNull
    protected abstract String getTitle();
}

