/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.branch.HgBranchUtil;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgCommitCommand;
import org.zmlx.hg4idea.command.HgMergeCommand;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgReferenceValidator;
import org.zmlx.hg4idea.util.HgUtil;

public class HgTaskHandler
extends DvcsTaskHandler<HgRepository> {
    private final HgReferenceValidator myNameValidator = HgReferenceValidator.getInstance();

    public HgTaskHandler(@NotNull Project project) {
        super((AbstractRepositoryManager)ServiceManager.getService((Project)project, HgRepositoryManager.class), project, "bookmark");
    }

    protected void checkout(@NotNull String taskName, @NotNull List<? extends HgRepository> repos, @Nullable Runnable callInAwtLater) {
        HgUpdateCommand.updateTo(!HgBranchUtil.getCommonBookmarks(repos).contains(taskName) ? "head() and not bookmark() and branch(\"" + taskName + "\")" : taskName, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<? extends HgRepository> repositories) {
        HgBookmarkCommand.createBookmarkAsynchronously(repositories, name, true);
    }

    protected String getActiveBranch(HgRepository repository) {
        String bookmark = repository.getCurrentBookmark();
        return bookmark == null ? repository.getCurrentBranch() : bookmark;
    }

    @NotNull
    protected Iterable<VcsTaskHandler.TaskInfo> getAllBranches(@NotNull HgRepository repository) {
        Iterable names = ContainerUtil.concat(HgUtil.getSortedNamesWithoutHashes(repository.getBookmarks()), repository.getOpenedBranches());
        return ContainerUtil.map((Iterable)names, s -> new VcsTaskHandler.TaskInfo(s, Collections.singleton(repository.getPresentableUrl())));
    }

    protected void mergeAndClose(@NotNull String branch, @NotNull List<? extends HgRepository> repositories) {
        String bookmarkRevisionArg = "bookmark(\"" + branch + "\")";
        FileDocumentManager.getInstance().saveAllDocuments();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (HgRepository hgRepository : repositories) {
            HgMergeCommand.mergeWith(hgRepository, bookmarkRevisionArg, updatedFiles, () -> {
                Project project = repository.getProject();
                VirtualFile repositoryRoot = repository.getRoot();
                try {
                    new HgCommitCommand(project, repository, "Automated merge with " + branch).executeInCurrentThread();
                    HgBookmarkCommand.deleteBookmarkSynchronously(project, repositoryRoot, branch);
                }
                catch (HgCommandException e) {
                    HgErrorUtil.handleException(project, e);
                }
                catch (VcsException e) {
                    VcsNotifier.getInstance((Project)project).notifyError(HgBundle.message("hg4idea.commit.merge.error", branch), e.getMessage());
                }
            });
        }
    }

    protected boolean hasBranch(@NotNull HgRepository repository, @NotNull VcsTaskHandler.TaskInfo name) {
        return HgUtil.getNamesWithoutHashes(repository.getBookmarks()).contains(name.getName()) || repository.getOpenedBranches().contains(name.getName());
    }

    public boolean isBranchNameValid(@NotNull String branchName) {
        return this.myNameValidator.checkInput(branchName);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        return this.myNameValidator.cleanUpBranchName(suggestedName);
    }
}

