/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.evaluation.AbsentInformationEvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0004\u001a$\u0010\u0005\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0004\u001a$\u0010\u0006\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0004\u001a'\u0010\u0007\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\f\u001a\u0012\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\t*\u00020\u000b\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t*\u00020\f\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\n\u001a\n\u0010\u0013\u001a\u00020\u0012*\u00020\n\u001a\u0012\u0010\u0013\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\n*\u00020\u0017\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0012\u001a\f\u0010\u001a\u001a\u0004\u0018\u00010\u000b*\u00020\n\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u00020\n\u001a\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u0015*\u00020\f\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u0017\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 \u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u0010\u001a\u0012\u0010!\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\t*\u00020\u000b\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010 *\u00020#2\u0006\u0010$\u001a\u00020\u0015\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020 0\t*\u00020#\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\t*\u00020\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"wrapAbsentInformationException", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "wrapClassNotLoadedException", "wrapEvaluateException", "wrapIllegalArgumentException", "safeAllLineLocations", "", "Lcom/sun/jdi/Location;", "Lcom/sun/jdi/Method;", "Lcom/sun/jdi/ReferenceType;", "safeArguments", "Lcom/sun/jdi/LocalVariable;", "safeFields", "Lcom/sun/jdi/Field;", "safeKotlinPreferredLineNumber", "", "safeLineNumber", "stratum", "", "safeLocation", "Lcom/intellij/debugger/engine/jdi/StackFrameProxy;", "safeLocationsOfLine", "line", "safeMethod", "safeSourceName", "safeStackFrame", "Lcom/sun/jdi/StackFrame;", "safeType", "Lcom/sun/jdi/Type;", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "safeVariables", "safeVisibleVariableByName", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "name", "safeVisibleVariables", "kotlin.jvm-debugger.util"})
public final class SafeUtilKt {
    @NotNull
    public static final List<LocalVariableProxyImpl> safeVisibleVariables(@NotNull StackFrameProxyImpl $this$safeVisibleVariables) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$safeVisibleVariables, (String)"$this$safeVisibleVariables");
        boolean $i$f$wrapAbsentInformationException = false;
        try {
            boolean bl = false;
            list2 = $this$safeVisibleVariables.visibleVariables();
        }
        catch (AbsentInformationException e$iv) {
            list2 = null;
        }
        catch (AbsentInformationEvaluateException e$iv) {
            list2 = null;
        }
        catch (InternalException e$iv) {
            list2 = null;
        }
        if ((list = list2) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final LocalVariableProxyImpl safeVisibleVariableByName(@NotNull StackFrameProxyImpl $this$safeVisibleVariableByName, @NotNull String name) {
        LocalVariableProxyImpl localVariableProxyImpl;
        Intrinsics.checkNotNullParameter((Object)$this$safeVisibleVariableByName, (String)"$this$safeVisibleVariableByName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean $i$f$wrapAbsentInformationException = false;
        try {
            boolean bl = false;
            localVariableProxyImpl = $this$safeVisibleVariableByName.visibleVariableByName(name);
        }
        catch (AbsentInformationException e$iv) {
            localVariableProxyImpl = null;
        }
        catch (AbsentInformationEvaluateException e$iv) {
            localVariableProxyImpl = null;
        }
        catch (InternalException e$iv) {
            localVariableProxyImpl = null;
        }
        return localVariableProxyImpl;
    }

    @NotNull
    public static final List<LocalVariable> safeVisibleVariables(@NotNull StackFrame $this$safeVisibleVariables) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$safeVisibleVariables, (String)"$this$safeVisibleVariables");
        boolean $i$f$wrapAbsentInformationException = false;
        try {
            boolean bl = false;
            list2 = $this$safeVisibleVariables.visibleVariables();
        }
        catch (AbsentInformationException e$iv) {
            list2 = null;
        }
        catch (AbsentInformationEvaluateException e$iv) {
            list2 = null;
        }
        catch (InternalException e$iv) {
            list2 = null;
        }
        if ((list = list2) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<Location> safeAllLineLocations(@NotNull Method $this$safeAllLineLocations) {
        Intrinsics.checkNotNullParameter((Object)$this$safeAllLineLocations, (String)"$this$safeAllLineLocations");
        List list = DebuggerUtilsEx.allLineLocations((Method)$this$safeAllLineLocations);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<Location> safeAllLineLocations(@NotNull ReferenceType $this$safeAllLineLocations) {
        Intrinsics.checkNotNullParameter((Object)$this$safeAllLineLocations, (String)"$this$safeAllLineLocations");
        List list = DebuggerUtilsEx.allLineLocations((ReferenceType)$this$safeAllLineLocations);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final String safeSourceName(@NotNull ReferenceType $this$safeSourceName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$safeSourceName, (String)"$this$safeSourceName");
        boolean $i$f$wrapAbsentInformationException = false;
        try {
            boolean bl = false;
            string = $this$safeSourceName.sourceName();
        }
        catch (AbsentInformationException e$iv) {
            string = null;
        }
        catch (AbsentInformationEvaluateException e$iv) {
            string = null;
        }
        catch (InternalException e$iv) {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final List<Field> safeFields(@NotNull ReferenceType $this$safeFields) {
        List<Field> list;
        Intrinsics.checkNotNullParameter((Object)$this$safeFields, (String)"$this$safeFields");
        try {
            List<Field> list2 = $this$safeFields.fields();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"fields()");
            list = list2;
        }
        catch (ClassNotPreparedException e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final List<Location> safeLocationsOfLine(@NotNull Method $this$safeLocationsOfLine, int line) {
        List list;
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$safeLocationsOfLine, (String)"$this$safeLocationsOfLine");
        boolean $i$f$wrapAbsentInformationException = false;
        try {
            boolean bl = false;
            list2 = $this$safeLocationsOfLine.locationsOfLine(line);
        }
        catch (AbsentInformationException e$iv) {
            list2 = null;
        }
        catch (AbsentInformationEvaluateException e$iv) {
            list2 = null;
        }
        catch (InternalException e$iv) {
            list2 = null;
        }
        if ((list = list2) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public static final List<LocalVariable> safeVariables(@NotNull Method $this$safeVariables) {
        List<LocalVariable> list;
        Intrinsics.checkNotNullParameter((Object)$this$safeVariables, (String)"$this$safeVariables");
        boolean $i$f$wrapAbsentInformationException = false;
        try {
            boolean bl = false;
            list = $this$safeVariables.variables();
        }
        catch (AbsentInformationException e$iv) {
            list = null;
        }
        catch (AbsentInformationEvaluateException e$iv) {
            list = null;
        }
        catch (InternalException e$iv) {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final List<LocalVariable> safeArguments(@NotNull Method $this$safeArguments) {
        List<LocalVariable> list;
        Intrinsics.checkNotNullParameter((Object)$this$safeArguments, (String)"$this$safeArguments");
        boolean $i$f$wrapAbsentInformationException = false;
        try {
            boolean bl = false;
            list = $this$safeArguments.arguments();
        }
        catch (AbsentInformationException e$iv) {
            list = null;
        }
        catch (AbsentInformationEvaluateException e$iv) {
            list = null;
        }
        catch (InternalException e$iv) {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Location safeLocation(@NotNull StackFrameProxy $this$safeLocation) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)$this$safeLocation, (String)"$this$safeLocation");
        boolean $i$f$wrapEvaluateException = false;
        try {
            boolean bl = false;
            location = $this$safeLocation.location();
        }
        catch (EvaluateException e$iv) {
            location = null;
        }
        return location;
    }

    @Nullable
    public static final StackFrame safeStackFrame(@NotNull StackFrameProxy $this$safeStackFrame) {
        StackFrame stackFrame;
        Intrinsics.checkNotNullParameter((Object)$this$safeStackFrame, (String)"$this$safeStackFrame");
        boolean $i$f$wrapEvaluateException = false;
        try {
            boolean bl = false;
            stackFrame = $this$safeStackFrame.getStackFrame();
        }
        catch (EvaluateException e$iv) {
            stackFrame = null;
        }
        return stackFrame;
    }

    @Nullable
    public static final String safeSourceName(@NotNull Location $this$safeSourceName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$safeSourceName, (String)"$this$safeSourceName");
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            String string2;
            boolean bl = false;
            boolean $i$f$wrapAbsentInformationException = false;
            try {
                boolean bl2 = false;
                string2 = $this$safeSourceName.sourceName();
            }
            catch (AbsentInformationException e$iv) {
                string2 = null;
            }
            catch (AbsentInformationEvaluateException e$iv) {
                string2 = null;
            }
            catch (InternalException e$iv) {
                string2 = null;
            }
            string = string2;
        }
        catch (IllegalArgumentException e$iv) {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String safeSourceName(@NotNull Location $this$safeSourceName, @NotNull String stratum) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$safeSourceName, (String)"$this$safeSourceName");
        Intrinsics.checkNotNullParameter((Object)stratum, (String)"stratum");
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            String string2;
            boolean bl = false;
            boolean $i$f$wrapAbsentInformationException = false;
            try {
                boolean bl2 = false;
                string2 = $this$safeSourceName.sourceName(stratum);
            }
            catch (AbsentInformationException e$iv) {
                string2 = null;
            }
            catch (AbsentInformationEvaluateException e$iv) {
                string2 = null;
            }
            catch (InternalException e$iv) {
                string2 = null;
            }
            string = string2;
        }
        catch (IllegalArgumentException e$iv) {
            string = null;
        }
        return string;
    }

    public static final int safeLineNumber(@NotNull Location $this$safeLineNumber) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$safeLineNumber, (String)"$this$safeLineNumber");
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            boolean bl = false;
            n = DebuggerUtilsEx.getLineNumber((Location)$this$safeLineNumber, (boolean)false);
        }
        catch (IllegalArgumentException e$iv) {
            n = null;
        }
        Integer n2 = n;
        return n2 != null ? n2 : -1;
    }

    public static final int safeLineNumber(@NotNull Location $this$safeLineNumber, @NotNull String stratum) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$safeLineNumber, (String)"$this$safeLineNumber");
        Intrinsics.checkNotNullParameter((Object)stratum, (String)"stratum");
        try {
            n = $this$safeLineNumber.lineNumber(stratum);
        }
        catch (InternalError e) {
            n = -1;
        }
        catch (IllegalArgumentException e) {
            n = -1;
        }
        return n;
    }

    public static final int safeKotlinPreferredLineNumber(@NotNull Location $this$safeKotlinPreferredLineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$safeKotlinPreferredLineNumber, (String)"$this$safeKotlinPreferredLineNumber");
        int kotlinLineNumber = SafeUtilKt.safeLineNumber($this$safeKotlinPreferredLineNumber, "Kotlin");
        if (kotlinLineNumber > 0) {
            return kotlinLineNumber;
        }
        return SafeUtilKt.safeLineNumber($this$safeKotlinPreferredLineNumber, "Java");
    }

    @Nullable
    public static final Method safeMethod(@NotNull Location $this$safeMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$safeMethod, (String)"$this$safeMethod");
        return DebuggerUtilsEx.getMethod((Location)$this$safeMethod);
    }

    @Nullable
    public static final Type safeType(@NotNull LocalVariableProxyImpl $this$safeType) {
        Type type;
        Intrinsics.checkNotNullParameter((Object)$this$safeType, (String)"$this$safeType");
        boolean $i$f$wrapClassNotLoadedException = false;
        try {
            boolean bl = false;
            type = $this$safeType.getType();
        }
        catch (ClassNotLoadedException e$iv) {
            type = null;
        }
        return type;
    }

    @Nullable
    public static final Type safeType(@NotNull Field $this$safeType) {
        Type type;
        Intrinsics.checkNotNullParameter((Object)$this$safeType, (String)"$this$safeType");
        boolean $i$f$wrapClassNotLoadedException = false;
        try {
            boolean bl = false;
            type = $this$safeType.type();
        }
        catch (ClassNotLoadedException e$iv) {
            type = null;
        }
        return type;
    }

    private static final <T> T wrapEvaluateException(Function0<? extends T> block) {
        Object object;
        int $i$f$wrapEvaluateException = 0;
        try {
            object = block.invoke();
        }
        catch (EvaluateException e) {
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public static final <T> T wrapIllegalArgumentException(@NotNull Function0<? extends T> block) {
        Object object;
        int $i$f$wrapIllegalArgumentException = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (IllegalArgumentException e) {
            object = null;
        }
        return (T)object;
    }

    private static final <T> T wrapAbsentInformationException(Function0<? extends T> block) {
        Object object;
        int $i$f$wrapAbsentInformationException = 0;
        try {
            object = block.invoke();
        }
        catch (AbsentInformationException e) {
            object = null;
        }
        catch (AbsentInformationEvaluateException e) {
            object = null;
        }
        catch (InternalException e) {
            object = null;
        }
        return (T)object;
    }

    private static final <T> T wrapClassNotLoadedException(Function0<? extends T> block) {
        Object object;
        int $i$f$wrapClassNotLoadedException = 0;
        try {
            object = block.invoke();
        }
        catch (ClassNotLoadedException e) {
            object = null;
        }
        return (T)object;
    }
}

