/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.sun.jdi.LocalVariable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005\u001a\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000e"}, d2={"INLINED_THIS_REGEX", "Lkotlin/text/Regex;", "getINLINED_THIS_REGEX", "()Lkotlin/text/Regex;", "dropInlineSuffix", "", "name", "getInlineDepth", "", "variableName", "variables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "getLocalVariableNameRegexInlineAware", "kotlin.jvm-debugger.util"})
public final class InlineUtilsKt {
    @NotNull
    private static final Regex INLINED_THIS_REGEX = InlineUtilsKt.getLocalVariableNameRegexInlineAware("this_");

    @NotNull
    public static final Regex getINLINED_THIS_REGEX() {
        return INLINED_THIS_REGEX;
    }

    public static final int getInlineDepth(@NotNull List<? extends LocalVariableProxyImpl> variables) {
        int n;
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Iterable $this$count$iv = variables;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LocalVariableProxyImpl it = (LocalVariableProxyImpl)element$iv;
                boolean bl = false;
                String string = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                if (!StringsKt.startsWith$default((String)string, (String)"$i$f$", (boolean)false, (int)2, null)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int rawInlineFunDepth = n;
        Iterable $this$sortedByDescending$iv = variables;
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        for (LocalVariableProxyImpl variable : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                LocalVariableProxyImpl it = (LocalVariableProxyImpl)b;
                boolean bl2 = false;
                Comparable comparable = it.getVariable();
                it = (LocalVariableProxyImpl)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                LocalVariable localVariable = it.getVariable();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)localVariable);
            }
        })) {
            String name;
            String string = name = variable.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            int depth = InlineUtilsKt.getInlineDepth(string);
            if (depth > 0) {
                return depth;
            }
            if (!StringsKt.startsWith$default((String)name, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            return 0;
        }
        return rawInlineFunDepth;
    }

    public static final int getInlineDepth(@NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        int depth = 0;
        int suffixLen = "$iv".length();
        for (int endIndex = variableName.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
            String string = variableName;
            int n = endIndex - suffixLen;
            boolean bl = false;
            String string2 = string.substring(n, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (Intrinsics.areEqual((Object)string2, (Object)"$iv") ^ true) break;
            ++depth;
        }
        return depth;
    }

    @NotNull
    public static final String dropInlineSuffix(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int depth = InlineUtilsKt.getInlineDepth(name);
        if (depth == 0) {
            return name;
        }
        return StringsKt.dropLast((String)name, (int)(depth * "$iv".length()));
    }

    private static final Regex getLocalVariableNameRegexInlineAware(String name) {
        String escapedName = Regex.Companion.escape(name);
        String escapedSuffix = Regex.Companion.escape("$iv");
        return new Regex('^' + escapedName + "(?:" + escapedSuffix + ")*$");
    }
}

