/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.whitelist;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.whitelist.BaseWhitelistStorage;
import com.intellij.internal.statistic.eventLog.whitelist.EventLogMetadataLoader;
import com.intellij.internal.statistic.eventLog.whitelist.EventLogServerWhitelistLoader;
import com.intellij.internal.statistic.service.fus.EventLogMetadataLoadException;
import com.intellij.internal.statistic.service.fus.EventLogMetadataParseException;
import com.intellij.internal.statistic.service.fus.EventLogMetadataUpdateError;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhitelistStorage
extends BaseWhitelistStorage {
    private static final Logger LOG = Logger.getInstance(WhitelistStorage.class);
    protected final ConcurrentMap<String, EventGroupRules> eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
    @NotNull
    private final Semaphore mySemaphore;
    @NotNull
    private final String myRecorderId;
    @Nullable
    private String myVersion;
    @NotNull
    private final EventLogWhitelistPersistence myWhitelistPersistence;
    @NotNull
    private final EventLogMetadataLoader myWhitelistLoader;

    WhitelistStorage(@NotNull String recorderId) {
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myWhitelistPersistence = new EventLogWhitelistPersistence(recorderId);
        this.myWhitelistLoader = new EventLogServerWhitelistLoader(recorderId);
        this.myVersion = this.loadValidatorsFromLocalCache(recorderId);
    }

    protected WhitelistStorage(@NotNull String recorderId, @NotNull EventLogWhitelistPersistence persistence, @NotNull EventLogMetadataLoader loader) {
        this.myRecorderId = recorderId;
        this.mySemaphore = new Semaphore();
        this.myWhitelistPersistence = persistence;
        this.myWhitelistLoader = loader;
        this.myVersion = this.loadValidatorsFromLocalCache(recorderId);
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        return (EventGroupRules)this.eventsValidators.get(groupId);
    }

    @Nullable
    private String loadValidatorsFromLocalCache(@NotNull String recorderId) {
        String whiteListContent = this.myWhitelistPersistence.getCachedMetadata();
        if (whiteListContent != null) {
            try {
                String newVersion = this.updateValidators(whiteListContent);
                EventLogSystemLogger.logMetadataLoad(recorderId, newVersion);
                return newVersion;
            }
            catch (EventLogMetadataParseException e) {
                EventLogSystemLogger.logMetadataErrorOnLoad(this.myRecorderId, (EventLogMetadataUpdateError)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String updateValidators(@NotNull String whiteListContent) throws EventLogMetadataParseException {
        this.mySemaphore.down();
        try {
            FUStatisticsWhiteListGroupsService.WLGroups groups = FUStatisticsWhiteListGroupsService.parseWhiteListContent((String)whiteListContent);
            EventLogBuild build2 = EventLogBuild.fromString((String)EventLogConfiguration.INSTANCE.getBuild());
            Map<String, EventGroupRules> result = this.createValidators(build2, groups);
            this.isWhiteListInitialized.set(false);
            this.eventsValidators.clear();
            this.eventsValidators.putAll(result);
            this.isWhiteListInitialized.set(true);
            String string = groups.version;
            return string;
        }
        finally {
            this.mySemaphore.up();
        }
    }

    @Override
    public void update() {
        long lastModifiedLocally = this.myWhitelistPersistence.getLastModified();
        long lastModifiedOnServer = this.myWhitelistLoader.getLastModifiedOnServer();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Loading whitelist, last modified cached=" + lastModifiedLocally + ", last modified on the server=" + lastModifiedOnServer);
        }
        try {
            if (lastModifiedOnServer <= 0L || lastModifiedOnServer > lastModifiedLocally || this.isUnreachableWhitelist()) {
                String whitelistFromServer = this.myWhitelistLoader.loadMetadataFromServer();
                String version = this.updateValidators(whitelistFromServer);
                this.myWhitelistPersistence.cacheWhiteList(whitelistFromServer, lastModifiedOnServer);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Update local whitelist, last modified cached=" + this.myWhitelistPersistence.getLastModified());
                }
                if (version != null && !StringUtil.equals((CharSequence)version, (CharSequence)this.myVersion)) {
                    this.myVersion = version;
                    EventLogSystemLogger.logMetadataUpdated(this.myRecorderId, this.myVersion);
                }
            }
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            EventLogSystemLogger.logMetadataErrorOnUpdate(this.myRecorderId, (EventLogMetadataUpdateError)e);
        }
    }

    @Override
    public void reload() {
        this.myVersion = this.loadValidatorsFromLocalCache(this.myRecorderId);
    }
}

