/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import org.jetbrains.annotations.NotNull;

public class UtilExpressionValidationRule
extends PerformanceCareRule
implements FUSRule {
    @NotNull
    private final FUSRule myRule;
    @NotNull
    private final String myPrefix;
    @NotNull
    private final String mySuffix;

    public UtilExpressionValidationRule(@NotNull FUSRule rule, @NotNull String prefix, @NotNull String suffix) {
        this.myRule = rule;
        this.myPrefix = prefix;
        this.mySuffix = suffix;
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        String escapedData = StatisticsEventEscaper.escape((String)data);
        if (this.acceptPrefix(escapedData) && this.acceptSuffix(escapedData)) {
            return this.myRule.validate(escapedData.substring(this.myPrefix.length(), escapedData.length() - this.mySuffix.length()), context);
        }
        return ValidationResultType.REJECTED;
    }

    private boolean acceptPrefix(@NotNull String data) {
        return this.myPrefix.isEmpty() || data.startsWith(this.myPrefix);
    }

    private boolean acceptSuffix(@NotNull String data) {
        return this.mySuffix.isEmpty() || data.endsWith(this.mySuffix);
    }

    public String toString() {
        return "UtilExpressionValidationRule: myPrefix=" + this.myPrefix + ",mySuffix=" + this.mySuffix + ",myRule=" + this.myRule;
    }
}

