/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileCustomValidationRule
extends CustomValidationRule {
    private static final Logger LOG = Logger.getInstance(LocalFileCustomValidationRule.class);
    private WeakReference<CachedAllowedItems> myAllowedItemsRef;
    private final String myRuleId;
    private final Class myResourceHolder;
    private final String myRelativePath;

    protected LocalFileCustomValidationRule(@NotNull String ruleId, @NotNull Class resource, @NotNull String path) {
        this.myRuleId = ruleId;
        this.myResourceHolder = resource;
        this.myRelativePath = path;
    }

    @Override
    public boolean acceptRuleId(@Nullable String ruleId) {
        return this.myRuleId.equals(ruleId);
    }

    private boolean isAllowed(@NotNull String value) {
        CachedAllowedItems allowed = this.getAllowedItems();
        return allowed.contains(value);
    }

    @NotNull
    private synchronized CachedAllowedItems getAllowedItems() {
        CachedAllowedItems allowed = (CachedAllowedItems)SoftReference.dereference(this.myAllowedItemsRef);
        if (allowed != null) {
            return allowed;
        }
        CachedAllowedItems items = this.create();
        this.myAllowedItemsRef = new WeakReference<CachedAllowedItems>(items);
        return items;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private CachedAllowedItems create() {
        try {
            InputStream resourceStream = this.myResourceHolder.getResourceAsStream(this.myRelativePath);
            if (resourceStream == null) {
                throw new IOException("Resource " + this.myRelativePath + " not found");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
                List values = FileUtil.loadLines((BufferedReader)reader);
                if (values.isEmpty()) return CachedAllowedItems.empty();
                CachedAllowedItems cachedAllowedItems = CachedAllowedItems.create(ContainerUtil.map2SetNotNull((Collection)values, value -> this.createValue((String)value)));
                return cachedAllowedItems;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return CachedAllowedItems.empty();
    }

    @Nullable
    protected String createValue(String value) {
        return value.trim();
    }

    @Override
    @NotNull
    protected final ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (LocalFileCustomValidationRule.isThirdPartyValue(data) || this.isAllowed(data)) {
            return ValidationResultType.ACCEPTED;
        }
        return ValidationResultType.REJECTED;
    }

    private static class CachedAllowedItems {
        private final Set<String> myValues;

        private CachedAllowedItems(@NotNull Set<String> values) {
            this.myValues = values;
        }

        public boolean contains(@NotNull String value) {
            return this.myValues.contains(value);
        }

        @NotNull
        public static CachedAllowedItems create(@NotNull Set<String> values) {
            return new CachedAllowedItems(values);
        }

        @NotNull
        public static CachedAllowedItems empty() {
            return new CachedAllowedItems(Collections.emptySet());
        }
    }
}

