/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRegexpAwareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RegexpValidationRule;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumValidationRule
extends PerformanceCareRule
implements FUSRegexpAwareRule {
    private final Collection<String> myEnumValues;

    public EnumValidationRule(@Nullable Collection<String> strings) {
        this.myEnumValues = strings == null ? Collections.emptySet() : ContainerUtil.unmodifiableOrEmptyCollection(strings);
    }

    @Override
    @NotNull
    public ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (this.myEnumValues.isEmpty()) {
            return ValidationResultType.INCORRECT_RULE;
        }
        return this.myEnumValues.contains(StatisticsEventEscaper.escape((String)data)) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
    }

    @Override
    @NotNull
    public String asRegexp() {
        return StringUtil.join((Collection)ContainerUtil.map(this.myEnumValues, s -> RegexpValidationRule.escapeText(s)), (String)"|");
    }

    public String toString() {
        return "EnumValidationRule: myEnumValues=" + this.asRegexp();
    }
}

