/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.service.fus.FUStatisticsWhiteListGroupsService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventGroupRules {
    public static final EventGroupRules EMPTY = new EventGroupRules(Collections.emptySet(), Collections.emptyMap(), EventGroupContextData.EMPTY);
    private final FUSRule[] eventIdRules;
    private final Map<String, FUSRule[]> eventDataRules = new ConcurrentHashMap<String, FUSRule[]>();

    private EventGroupRules(@Nullable Set<String> eventIdRules, @Nullable Map<String, Set<String>> eventDataRules, @NotNull EventGroupContextData contextData) {
        this.eventIdRules = EventGroupRules.getRules(eventIdRules, contextData);
        if (eventDataRules != null) {
            for (Map.Entry<String, Set<String>> entry : eventDataRules.entrySet()) {
                if (FeatureUsageData.Companion.getPlatformDataKeys().contains(entry.getKey())) {
                    this.eventDataRules.put(entry.getKey(), new FUSRule[]{FUSRule.TRUE});
                    continue;
                }
                this.eventDataRules.put(entry.getKey(), EventGroupRules.getRules(entry.getValue(), contextData));
            }
        }
    }

    public FUSRule[] getEventIdRules() {
        return this.eventIdRules;
    }

    public Map<String, FUSRule[]> getEventDataRules() {
        return this.eventDataRules;
    }

    private static FUSRule @NotNull [] getRules(@Nullable Set<String> rules, @NotNull EventGroupContextData contextData) {
        if (rules == null) {
            return FUSRule.EMPTY_ARRAY;
        }
        SortedList fusRules = new SortedList(EventGroupRules.getRulesComparator());
        for (String rule : rules) {
            ContainerUtil.addIfNotNull((Collection)fusRules, (Object)ValidationSimpleRuleFactory.createRule(rule, contextData));
        }
        return fusRules.toArray(FUSRule.EMPTY_ARRAY);
    }

    @NotNull
    private static Comparator<FUSRule> getRulesComparator() {
        return (o1, o2) -> {
            if (o1 instanceof EnumValidationRule) {
                return o2 instanceof EnumValidationRule ? -1 : 0;
            }
            return o2 instanceof EnumValidationRule ? 0 : 1;
        };
    }

    public boolean areEventIdRulesDefined() {
        return this.eventIdRules.length > 0;
    }

    public boolean areEventDataRulesDefined() {
        return this.eventDataRules.size() > 0;
    }

    public ValidationResultType validateEventId(@NotNull EventContext context) {
        ValidationResultType prevResult = null;
        for (FUSRule rule : this.eventIdRules) {
            ValidationResultType resultType = rule.validate(context.eventId, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    public Object validateEventData(@NotNull String key, @Nullable Object data, @NotNull EventContext context) {
        if (FeatureUsageData.Companion.getPlatformDataKeys().contains(key)) {
            return data;
        }
        if (data == null) {
            return ValidationResultType.REJECTED.getDescription();
        }
        if (data instanceof Map) {
            HashMap validatedData = new HashMap();
            for (Map.Entry entry : ((Map)data).entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey instanceof String) {
                    validatedData.put(entryKey, this.validateEventData(key + "." + entryKey, entry.getValue(), context));
                    continue;
                }
                validatedData.put(entryKey, ValidationResultType.REJECTED.getDescription());
            }
            return validatedData;
        }
        if (data instanceof List) {
            return ContainerUtil.map((Collection)((List)data), value -> this.validateEventData(key, value, context));
        }
        FUSRule[] rules = this.eventDataRules.get(key);
        if (rules == null || rules.length == 0) {
            return ValidationResultType.UNDEFINED_RULE.getDescription();
        }
        return EventGroupRules.validateValue(data, context, rules);
    }

    private static Object validateValue(@NotNull Object data, @NotNull EventContext context, FUSRule @NotNull [] rules) {
        ValidationResultType resultType = EventGroupRules.acceptRule(data.toString(), context, rules);
        return resultType == ValidationResultType.ACCEPTED ? data : resultType.getDescription();
    }

    private static ValidationResultType acceptRule(@NotNull String ruleData, @NotNull EventContext context, FUSRule ... rules) {
        if (rules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        ValidationResultType prevResult = null;
        for (FUSRule rule : rules) {
            ValidationResultType resultType = rule.validate(ruleData, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    @NotNull
    public static EventGroupRules create(@NotNull FUStatisticsWhiteListGroupsService.WLGroup group, @Nullable Map<String, Set<String>> globalEnums, @Nullable Map<String, String> globalRegexps) {
        FUStatisticsWhiteListGroupsService.WLRule rules = group.rules;
        return rules == null ? EMPTY : new EventGroupRules(rules.event_id, rules.event_data, EventGroupContextData.create(rules.enums, globalEnums, rules.regexps, globalRegexps));
    }
}

