/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;

public class JpsJavaSdkType
extends JpsSdkType<JpsDummyElement>
implements JpsElementTypeWithDefaultProperties<JpsDummyElement> {
    public static final JpsJavaSdkType INSTANCE = new JpsJavaSdkType();

    @Override
    @NotNull
    public JpsDummyElement createDefaultProperties() {
        return JpsElementFactory.getInstance().createDummyElement();
    }

    @Override
    public String getPresentableName() {
        return "JDK";
    }

    public static String getJavaExecutable(JpsSdk<?> sdk) {
        return sdk.getHomePath() + "/bin/java";
    }

    public String toString() {
        return "java sdk type";
    }

    public static int getJavaVersion(@Nullable JpsSdk<?> sdk) {
        return JpsJavaSdkType.parseVersion(sdk != null && sdk.getSdkType() instanceof JpsJavaSdkType ? sdk.getVersionString() : null);
    }

    public static int parseVersion(String javaVersionString) {
        JavaVersion version = JavaVersion.tryParse((String)javaVersionString);
        return version != null ? version.feature : 0;
    }

    @NotNull
    public static String complianceOption(@NotNull JavaVersion version) {
        return version.feature < 5 ? "1." + version.feature : String.valueOf(version.feature);
    }
}

