/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.SmoothScrollUtil;
import com.intellij.util.ui.TimerUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.Timer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class MouseWheelSmoothScroll {
    private final InertialAnimator horizontal = new InertialAnimator();
    private final InertialAnimator vertical = new InertialAnimator();
    @NotNull
    private final Supplier<Boolean> myScrollEnabled;

    public static MouseWheelSmoothScroll create() {
        return MouseWheelSmoothScroll.create(() -> true);
    }

    public static MouseWheelSmoothScroll create(@NotNull Supplier<Boolean> isScrollEnabled) {
        return new MouseWheelSmoothScroll(isScrollEnabled);
    }

    private MouseWheelSmoothScroll(@NotNull Supplier<Boolean> isEnabledChecker) {
        this.myScrollEnabled = Objects.requireNonNull(isEnabledChecker);
    }

    public void processMouseWheelEvent(@NotNull MouseWheelEvent e, @Nullable Consumer<MouseWheelEvent> alternative) {
        JScrollBar bar;
        JScrollBar jScrollBar = bar = this.myScrollEnabled.get() == false ? null : SmoothScrollUtil.getEventScrollBar(e);
        if (bar == null) {
            if (alternative != null) {
                alternative.accept(e);
            }
            return;
        }
        InertialAnimator animator = SmoothScrollUtil.isHorizontalScroll(e) ? this.horizontal : this.vertical;
        int value = bar.getValue();
        int delta = (int)MouseWheelSmoothScroll.getDelta(bar, e, animator.myTargetValue);
        if (delta == 0) {
            return;
        }
        animator.start(value, value + delta, bar::setValue, MouseWheelSmoothScroll.shouldStop(bar), ScrollAnimationSettings.SETTINGS);
        e.consume();
    }

    private static Predicate<Integer> shouldStop(JScrollBar bar) {
        return v -> v - bar.getValue() != 0 || !bar.isShowing();
    }

    private static double getDelta(@NotNull JScrollBar bar, @NotNull MouseWheelEvent event, double animationTargetValue) {
        JViewport viewport;
        int direction;
        double rotation = event.getPreciseWheelRotation();
        int n = direction = rotation < 0.0 ? -1 : 1;
        if (event.getScrollType() == 1) {
            return direction * bar.getBlockIncrement(direction);
        }
        if (event.getSource() instanceof JScrollPane && (viewport = ((JScrollPane)event.getSource()).getViewport()).getView() instanceof Scrollable) {
            int orientation = bar.getOrientation();
            boolean isVertical = orientation == 1;
            Scrollable scrollable = (Scrollable)((Object)viewport.getView());
            int scroll = Math.abs(event.getUnitsToScroll());
            Rectangle rect = viewport.getViewRect();
            int delta = 0;
            if (!Double.isNaN(animationTargetValue)) {
                if (isVertical) {
                    rect.y = (int)animationTargetValue;
                } else {
                    rect.x = (int)animationTargetValue;
                }
            }
            for (int i = 0; i < scroll; ++i) {
                int increment = Math.max(scrollable.getScrollableUnitIncrement(rect, orientation, direction), 0) * direction;
                if (isVertical) {
                    rect.y += increment;
                } else {
                    rect.x += increment;
                }
                delta += increment;
            }
            return delta;
        }
        int increment = bar.getUnitIncrement(direction);
        int delta = increment * event.getUnitsToScroll();
        return delta == 0 ? rotation : (double)delta;
    }

    static class CubicBezierEasing
    implements Easing {
        private final double[] xs;
        private final double[] ys;

        CubicBezierEasing(double c1x, double c1y, double c2x, double c2y, int size) {
            this.xs = new double[size];
            this.ys = new double[size];
            this.update(c1x, c1y, c2x, c2y);
        }

        public void update(double c1x, double c1y, double c2x, double c2y) {
            for (int i = 0; i < this.xs.length; ++i) {
                this.xs[i] = CubicBezierEasing.bezier((double)i * 1.0 / (double)this.xs.length, c1x, c2x);
                this.ys[i] = CubicBezierEasing.bezier((double)i * 1.0 / (double)this.xs.length, c1y, c2y);
            }
        }

        public int getSize() {
            assert (this.xs.length == this.ys.length);
            return this.xs.length;
        }

        @Override
        public double calc(double t, double b, double c, double d) {
            double x = t / d;
            int res = Arrays.binarySearch(this.xs, x);
            if (res < 0) {
                res = -res - 1;
            }
            return c * this.ys[Math.min(res, this.ys.length - 1)] + b;
        }

        private static double bezier(double t, double u1, double u2) {
            double v = 1.0 - t;
            return 3.0 * u1 * v * v * t + 3.0 * u2 * v * t * t + t * t * t;
        }
    }

    static interface Easing {
        public double calc(double var1, double var3, double var5, double var7);
    }

    static enum ScrollAnimationSettings implements AnimationSettings
    {
        SETTINGS{
            private CubicBezierEasing ourEasing;
            private int curvePoints;

            @Override
            public double getDuration() {
                return UISettings.getShadowInstance().getAnimatedScrollingDuration();
            }

            @Override
            @NotNull
            public Easing getEasing() {
                int points = UISettings.getShadowInstance().getAnimatedScrollingCurvePoints();
                if (points != this.curvePoints || this.ourEasing == null) {
                    double x1 = (double)(points >> 24 & 0xFF) / 200.0;
                    double y1 = (double)(points >> 16 & 0xFF) / 200.0;
                    double x2 = (double)(points >> 8 & 0xFF) / 200.0;
                    double y2 = (double)(points & 0xFF) / 200.0;
                    if (this.ourEasing == null) {
                        this.ourEasing = new CubicBezierEasing(x1, y1, x2, y2, 2000);
                    } else {
                        this.ourEasing.update(x1, y1, x2, y2);
                    }
                    this.curvePoints = points;
                }
                return this.ourEasing;
            }
        };

    }

    static interface AnimationSettings {
        public double getDuration();

        @NotNull
        public Easing getEasing();
    }

    static class InertialAnimator
    implements ActionListener {
        private static final int REFRESH_TIME = 6;
        private double myInitValue = Double.NaN;
        private double myCurrentValue = Double.NaN;
        private double myTargetValue = Double.NaN;
        private long myStartEventTime = -1L;
        private long myLastEventTime = -1L;
        private long myDuration = -1L;
        private AnimationSettings mySettings;
        private final Consumer<Integer> BLACK_HOLE = x -> {};
        @NotNull
        private Consumer<Integer> myConsumer = this.BLACK_HOLE;
        private final Predicate<Integer> FALSE_PREDICATE = value -> false;
        @NotNull
        private Predicate<Integer> myShouldStop = this.FALSE_PREDICATE;
        private final Timer myTimer = TimerUtil.createNamedTimer((String)"Inertial Animation Timer", (int)6, (ActionListener)this);

        InertialAnimator() {
            this.myTimer.setInitialDelay(0);
        }

        public final void start(int initValue, int targetValue, @NotNull Consumer<Integer> consumer, @Nullable Predicate<Integer> shouldStop, @NotNull AnimationSettings settings) {
            boolean isSameDirection;
            this.mySettings = settings;
            double duration = this.mySettings.getDuration();
            if (duration == 0.0) {
                consumer.accept(targetValue);
                this.stop();
                return;
            }
            boolean bl = isSameDirection = (this.myTargetValue - this.myInitValue) * (double)(targetValue - initValue) > 0.0;
            if (isSameDirection && this.myTimer.isRunning()) {
                this.myTargetValue += (double)(targetValue - initValue);
                this.myDuration = (long)duration + Math.max(this.myLastEventTime - this.myStartEventTime, 0L);
                this.myInitValue = this.myCurrentValue;
                this.myStartEventTime = this.myLastEventTime;
            } else {
                this.myTargetValue = targetValue;
                this.myDuration = (long)duration;
                this.myInitValue = initValue;
                this.myStartEventTime = System.currentTimeMillis();
            }
            this.myConsumer = Objects.requireNonNull(consumer);
            this.myShouldStop = shouldStop == null ? this.FALSE_PREDICATE : shouldStop;
            this.myCurrentValue = initValue;
            this.myTimer.start();
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            if (this.myShouldStop.test((int)Math.round(this.myCurrentValue))) {
                this.stop();
                return;
            }
            this.myLastEventTime = System.currentTimeMillis();
            long currentEventTime = Math.min(this.myLastEventTime, this.myStartEventTime + this.myDuration);
            this.myCurrentValue = this.mySettings.getEasing().calc(currentEventTime - this.myStartEventTime, this.myInitValue, this.myTargetValue - this.myInitValue, this.myDuration);
            this.myConsumer.accept((int)Math.round(this.myCurrentValue));
            if (this.myLastEventTime >= this.myStartEventTime + this.myDuration) {
                this.stop();
            }
        }

        public final void stop() {
            this.myTimer.stop();
            this.myStartEventTime = -1L;
            this.myLastEventTime = -1L;
            this.myDuration = -1L;
            this.myTargetValue = Double.NaN;
            this.myCurrentValue = Double.NaN;
            this.myInitValue = Double.NaN;
            this.myConsumer = this.BLACK_HOLE;
            this.myShouldStop = this.FALSE_PREDICATE;
            this.mySettings = null;
        }
    }
}

