/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateWrapper;
import java.io.FileInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CertificateUtil {
    public static final String X509 = "X.509";
    public static final String JKS = "JKS";
    public static final String PKCS12 = "PKCS12";
    public static final String PKIX = "PKIX";
    public static final String TLS = "TLS";
    private static final CertificateFactory ourFactory = CertificateUtil.createFactory();

    private static CertificateFactory createFactory() {
        try {
            return CertificateFactory.getInstance(X509);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Can't initialize X.509 certificate factory", e);
        }
    }

    private CertificateUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static X509Certificate loadX509Certificate(@NotNull String path2) {
        try (FileInputStream stream = new FileInputStream(path2);){
            X509Certificate x509Certificate = (X509Certificate)ourFactory.generateCertificate(stream);
            return x509Certificate;
        }
        catch (Exception e) {
            Logger.getInstance(CertificateUtil.class).error("Can't add certificate for path: " + path2, (Throwable)e);
            return null;
        }
    }

    public static String getCommonName(@NotNull X509Certificate certificate) {
        return new CertificateWrapper(certificate).getSubjectField(CertificateWrapper.CommonField.COMMON_NAME);
    }
}

