/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.AuthenticationDialog;
import com.intellij.util.net.AuthenticationPanel;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.net.IdeaWideAuthenticator;
import com.intellij.util.net.IdeaWideProxySelector;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.PropertiesEncryptionSupport;
import com.intellij.util.proxy.SharedProxyConfig;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="HttpConfigurable", storages={@Storage(value="proxy.settings.xml")}, reportStatistic=false)
public class HttpConfigurable
implements PersistentStateComponent<HttpConfigurable>,
Disposable {
    private static final Logger LOG = Logger.getInstance(HttpConfigurable.class);
    private static final File PROXY_CREDENTIALS_FILE = new File(PathManager.getOptionsPath(), "proxy.settings.pwd");
    public boolean PROXY_TYPE_IS_SOCKS;
    public boolean USE_HTTP_PROXY;
    public boolean USE_PROXY_PAC;
    public volatile transient boolean AUTHENTICATION_CANCELLED;
    public String PROXY_HOST;
    public int PROXY_PORT = 80;
    public volatile boolean PROXY_AUTHENTICATION;
    public boolean KEEP_PROXY_PASSWORD;
    public transient String LAST_ERROR;
    private final Map<CommonProxy.HostInfo, ProxyInfo> myGenericPasswords = new HashMap<CommonProxy.HostInfo, ProxyInfo>();
    private final Set<CommonProxy.HostInfo> myGenericCancelled = new HashSet<CommonProxy.HostInfo>();
    public String PROXY_EXCEPTIONS;
    public boolean USE_PAC_URL;
    public String PAC_URL;
    private transient IdeaWideProxySelector mySelector;
    private final transient Object myLock = new Object();
    private final transient PropertiesEncryptionSupport myEncryptionSupport = new PropertiesEncryptionSupport(new SecretKeySpec(new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99}, "AES"));
    private final transient NotNullLazyValue<Properties> myProxyCredentials = NotNullLazyValue.createValue(() -> {
        try {
            return this.myEncryptionSupport.load(PROXY_CREDENTIALS_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        return new Properties();
    });
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public static final int CONNECTION_TIMEOUT = HttpRequests.CONNECTION_TIMEOUT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public static final int READ_TIMEOUT = HttpRequests.READ_TIMEOUT;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public static final int REDIRECT_LIMIT = HttpRequests.REDIRECT_LIMIT;

    public static HttpConfigurable getInstance() {
        return ServiceManager.getService(HttpConfigurable.class);
    }

    public static boolean editConfigurable(@Nullable JComponent parent) {
        return ShowSettingsUtil.getInstance().editConfigurable((Component)parent, (Configurable)new HttpProxyConfigurable());
    }

    @Override
    public HttpConfigurable getState() {
        CommonProxy.isInstalledAssertion();
        HttpConfigurable state = new HttpConfigurable();
        XmlSerializerUtil.copyBean((Object)this, (Object)state);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.removeSecure("proxy.password");
        }
        this.correctPasswords(state);
        return state;
    }

    @Override
    public void noStateLoaded() {
        SharedProxyConfig.ProxyParameters cfg = SharedProxyConfig.load();
        if (cfg == null) {
            return;
        }
        SharedProxyConfig.clear();
        if (cfg.host == null) {
            return;
        }
        this.USE_HTTP_PROXY = true;
        this.PROXY_HOST = cfg.host;
        this.PROXY_PORT = cfg.port;
        if (cfg.login != null) {
            this.setPlainProxyPassword(new String(cfg.password));
            this.storeSecure("proxy.login", cfg.login);
            this.PROXY_AUTHENTICATION = true;
            this.KEEP_PROXY_PASSWORD = true;
        }
    }

    @Override
    public void initializeComponent() {
        this.mySelector = new IdeaWideProxySelector(this);
        String name = this.getClass().getName();
        CommonProxy.getInstance().setCustom(name, this.mySelector);
        CommonProxy.getInstance().setCustomAuth(name, new IdeaWideAuthenticator(this));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public void initComponent() {
        this.initializeComponent();
    }

    @NotNull
    public ProxySelector getOnlyBySettingsSelector() {
        return this.mySelector;
    }

    public void dispose() {
        String name = this.getClass().getName();
        CommonProxy.getInstance().removeCustom(name);
        CommonProxy.getInstance().removeCustomAuth(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctPasswords(@NotNull HttpConfigurable to) {
        Object object = this.myLock;
        synchronized (object) {
            to.myGenericPasswords.values().removeIf(it -> !it.isStore());
        }
    }

    @Override
    public void loadState(@NotNull HttpConfigurable state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.removeSecure("proxy.password");
        }
        this.correctPasswords(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGenericPasswordCanceled(@NotNull String host, int port) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myGenericCancelled.contains(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGenericPasswordCanceled(String host, int port) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericCancelled.add(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getGenericPassword(@NotNull String host, int port) {
        ProxyInfo proxyInfo;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myGenericPasswords.isEmpty()) {
                return null;
            }
            proxyInfo = this.myGenericPasswords.get(new CommonProxy.HostInfo(null, host, port));
        }
        if (proxyInfo == null) {
            return null;
        }
        return new PasswordAuthentication(proxyInfo.getUsername(), HttpConfigurable.decode(String.valueOf(proxyInfo.getPasswordCrypt())).toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putGenericPassword(String host, int port, @NotNull PasswordAuthentication authentication, boolean remember) {
        PasswordAuthentication coded = new PasswordAuthentication(authentication.getUserName(), HttpConfigurable.encode(String.valueOf(authentication.getPassword())).toCharArray());
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.put(new CommonProxy.HostInfo(null, host, port), new ProxyInfo(remember, coded.getUserName(), String.valueOf(coded.getPassword())));
        }
    }

    @Transient
    @Nullable
    public String getProxyLogin() {
        return this.getSecure("proxy.login");
    }

    @Transient
    public void setProxyLogin(String login) {
        this.storeSecure("proxy.login", login);
    }

    @Transient
    @Nullable
    public String getPlainProxyPassword() {
        return this.getSecure("proxy.password");
    }

    @Transient
    public void setPlainProxyPassword(String password) {
        this.storeSecure("proxy.password", password);
    }

    private static String decode(String value) {
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }

    private static String encode(String password) {
        return Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8));
    }

    public PasswordAuthentication getGenericPromptedAuthentication(String prefix, String host, String prompt, int port, boolean remember) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        Ref value = Ref.create();
        HttpConfigurable.runAboveAll(() -> {
            if (this.isGenericPasswordCanceled(host, port)) {
                return;
            }
            PasswordAuthentication password = this.getGenericPassword(host, port);
            if (password != null) {
                value.set((Object)password);
                return;
            }
            AuthenticationDialog dialog = new AuthenticationDialog(PopupUtil.getActiveComponent(), prefix + host, IdeBundle.message("dialog.message.please.enter.credentials.for", prompt), "", "", remember);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                AuthenticationPanel panel2 = dialog.getPanel();
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(panel2.getLogin(), panel2.getPassword());
                this.putGenericPassword(host, port, passwordAuthentication, remember && panel2.isRememberPassword());
                value.set((Object)passwordAuthentication);
            } else {
                this.setGenericPasswordCanceled(host, port);
            }
        });
        return (PasswordAuthentication)value.get();
    }

    public PasswordAuthentication getPromptedAuthentication(String host, String prompt) {
        String login;
        if (this.AUTHENTICATION_CANCELLED) {
            return null;
        }
        String password = this.getPlainProxyPassword();
        if (this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)(login = this.getSecure("proxy.login"))) && !StringUtil.isEmptyOrSpaces((String)password)) {
            return new PasswordAuthentication(login, password.toCharArray());
        }
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        PasswordAuthentication[] value = new PasswordAuthentication[1];
        HttpConfigurable.runAboveAll(() -> {
            String login;
            if (this.AUTHENTICATION_CANCELLED) {
                return;
            }
            String password1 = this.getPlainProxyPassword();
            if (this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)(login = this.getSecure("proxy.login"))) && !StringUtil.isEmptyOrSpaces((String)password1)) {
                value[0] = new PasswordAuthentication(login, password1.toCharArray());
                return;
            }
            AuthenticationDialog dialog = new AuthenticationDialog(PopupUtil.getActiveComponent(), IdeBundle.message("dialog.title.proxy.authentication", host), IdeBundle.message("dialog.message.please.enter.credentials.for", prompt), this.getSecure("proxy.login"), "", this.KEEP_PROXY_PASSWORD);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                boolean keepPass;
                this.PROXY_AUTHENTICATION = true;
                AuthenticationPanel panel2 = dialog.getPanel();
                this.KEEP_PROXY_PASSWORD = keepPass = panel2.isRememberPassword();
                this.storeSecure("proxy.login", StringUtil.nullize((String)panel2.getLogin()));
                if (keepPass) {
                    this.setPlainProxyPassword(String.valueOf(panel2.getPassword()));
                } else {
                    this.removeSecure("proxy.password");
                }
                value[0] = new PasswordAuthentication(panel2.getLogin(), panel2.getPassword());
            } else {
                this.AUTHENTICATION_CANCELLED = true;
            }
        });
        return value[0];
    }

    private static void runAboveAll(@NotNull Runnable runnable) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null && progressIndicator.isModal()) {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(runnable);
        } else {
            Application app = ApplicationManager.getApplication();
            app.invokeAndWait(runnable, ModalityState.any());
        }
    }

    @Deprecated
    public void readExternal(Element element) throws InvalidDataException {
        this.loadState(XmlSerializer.deserialize(element, HttpConfigurable.class));
    }

    @Deprecated
    public void writeExternal(Element element) throws WriteExternalException {
        com.intellij.util.xmlb.XmlSerializer.serializeInto((Object)this.getState(), (Element)element);
        if (this.USE_PROXY_PAC && this.USE_HTTP_PROXY && !ApplicationManager.getApplication().isDisposed()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
                if (frame != null) {
                    this.USE_PROXY_PAC = false;
                    Messages.showMessageDialog(frame.getComponent(), IdeBundle.message("message.text.proxy.both.use.proxy.and.autodetect.proxy.set", new Object[0]), IdeBundle.message("dialog.title.proxy.setup", new Object[0]), Messages.getWarningIcon());
                    HttpConfigurable.editConfigurable(frame.getComponent());
                }
            }, ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareURL(@NotNull String url) throws IOException {
        URLConnection connection = this.openConnection(url);
        try {
            connection.connect();
            connection.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    @NotNull
    public URLConnection openConnection(@NotNull String location) throws IOException {
        URL url = new URL(location);
        URLConnection urlConnection = null;
        List<Proxy> proxies = CommonProxy.getInstance().select(url);
        if (ContainerUtil.isEmpty(proxies)) {
            urlConnection = url.openConnection();
        } else {
            IOException exception = null;
            for (Proxy proxy : proxies) {
                try {
                    urlConnection = url.openConnection(proxy);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            if (urlConnection == null && exception != null) {
                throw exception;
            }
        }
        assert (urlConnection != null);
        urlConnection.setReadTimeout(HttpRequests.READ_TIMEOUT);
        urlConnection.setConnectTimeout(HttpRequests.CONNECTION_TIMEOUT);
        return urlConnection;
    }

    @NotNull
    public HttpURLConnection openHttpConnection(@NotNull String location) throws IOException {
        URLConnection urlConnection = this.openConnection(location);
        if (urlConnection instanceof HttpURLConnection) {
            return (HttpURLConnection)urlConnection;
        }
        throw new IOException("Expected " + HttpURLConnection.class + ", but got " + urlConnection.getClass());
    }

    public boolean isHttpProxyEnabledForUrl(@Nullable String url) {
        if (!this.USE_HTTP_PROXY) {
            return false;
        }
        URI uri = url != null ? VfsUtil.toUri(url) : null;
        return uri == null || !this.isProxyException(uri.getHost());
    }

    @NotNull
    public List<Pair<String, String>> getJvmProperties(boolean withAutodetection, @Nullable URI uri) {
        ArrayList<Pair<String, String>> result;
        block8: {
            List<Proxy> proxies;
            block6: {
                boolean putCredentials;
                block7: {
                    if (!this.USE_HTTP_PROXY && !this.USE_PROXY_PAC) {
                        return Collections.emptyList();
                    }
                    if (uri != null && this.isProxyException(uri)) {
                        return Collections.emptyList();
                    }
                    result = new ArrayList<Pair<String, String>>();
                    if (!this.USE_HTTP_PROXY) break block6;
                    boolean bl = putCredentials = this.KEEP_PROXY_PASSWORD && StringUtil.isNotEmpty((String)this.getProxyLogin());
                    if (!this.PROXY_TYPE_IS_SOCKS) break block7;
                    result.add((Pair<String, String>)Pair.pair((Object)"socksProxyHost", (Object)this.PROXY_HOST));
                    result.add((Pair<String, String>)Pair.pair((Object)"socksProxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                    if (putCredentials) {
                        result.add((Pair<String, String>)Pair.pair((Object)"java.net.socks.username", (Object)this.getProxyLogin()));
                        result.add((Pair<String, String>)Pair.pair((Object)"java.net.socks.password", (Object)this.getPlainProxyPassword()));
                    }
                    break block8;
                }
                result.add((Pair<String, String>)Pair.pair((Object)"http.proxyHost", (Object)this.PROXY_HOST));
                result.add((Pair<String, String>)Pair.pair((Object)"http.proxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                result.add((Pair<String, String>)Pair.pair((Object)"https.proxyHost", (Object)this.PROXY_HOST));
                result.add((Pair<String, String>)Pair.pair((Object)"https.proxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                if (!putCredentials) break block8;
                result.add((Pair<String, String>)Pair.pair((Object)"proxy.authentication.username", (Object)this.getProxyLogin()));
                result.add((Pair<String, String>)Pair.pair((Object)"proxy.authentication.password", (Object)this.getPlainProxyPassword()));
                break block8;
            }
            if (withAutodetection && uri != null && (proxies = CommonProxy.getInstance().select(uri)) != null && !proxies.isEmpty()) {
                for (Proxy proxy : proxies) {
                    SocketAddress address;
                    if (!HttpConfigurable.isRealProxy(proxy) || !((address = proxy.address()) instanceof InetSocketAddress)) continue;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    if (Proxy.Type.SOCKS.equals((Object)proxy.type())) {
                        result.add((Pair<String, String>)Pair.pair((Object)"socksProxyHost", (Object)inetSocketAddress.getHostName()));
                        result.add((Pair<String, String>)Pair.pair((Object)"socksProxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                        continue;
                    }
                    result.add((Pair<String, String>)Pair.pair((Object)"http.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((Pair<String, String>)Pair.pair((Object)"http.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                    result.add((Pair<String, String>)Pair.pair((Object)"https.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((Pair<String, String>)Pair.pair((Object)"https.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                }
            }
        }
        return result;
    }

    public boolean isProxyException(URI uri) {
        String uriHost = uri.getHost();
        return this.isProxyException(uriHost);
    }

    @Contract(value="null -> false")
    private boolean isProxyException(@Nullable String uriHost) {
        if (StringUtil.isEmptyOrSpaces((String)uriHost) || StringUtil.isEmptyOrSpaces((String)this.PROXY_EXCEPTIONS)) {
            return false;
        }
        List hosts = StringUtil.split((String)this.PROXY_EXCEPTIONS, (String)",");
        for (String hostPattern : hosts) {
            String regexpPattern = StringUtil.escapeToRegexp((String)hostPattern.trim()).replace("\\*", ".*");
            if (!Pattern.compile(regexpPattern).matcher(uriHost).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean isRealProxy(@NotNull Proxy proxy) {
        return !Proxy.NO_PROXY.equals(proxy) && !Proxy.Type.DIRECT.equals((Object)proxy.type());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGenericPasswords() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.clear();
            this.myGenericCancelled.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeneric(@NotNull CommonProxy.HostInfo info) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.remove(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSecure(String key) {
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                return props.getProperty(key, null);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSecure(String key, @Nullable String value) {
        if (value == null) {
            this.removeSecure(key);
            return;
        }
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                props.setProperty(key, value);
                this.myEncryptionSupport.store(props, "Proxy Credentials", PROXY_CREDENTIALS_FILE);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSecure(String key) {
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                props.remove(key);
                this.myEncryptionSupport.store(props, "Proxy Credentials", PROXY_CREDENTIALS_FILE);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static List<KeyValue<String, String>> getJvmPropertiesList(boolean withAutodetection, @Nullable URI uri) {
        List<Pair<String, String>> properties = HttpConfigurable.getInstance().getJvmProperties(withAutodetection, uri);
        return ContainerUtil.map(properties, p -> KeyValue.create((Object)p.first, (Object)p.second));
    }

    public static class ProxyInfo {
        public boolean myStore;
        public String myUsername;
        public String myPasswordCrypt;

        public ProxyInfo() {
        }

        public ProxyInfo(boolean store, String username, String passwordCrypt) {
            this.myStore = store;
            this.myUsername = username;
            this.myPasswordCrypt = passwordCrypt;
        }

        public boolean isStore() {
            return this.myStore;
        }

        public void setStore(boolean store) {
            this.myStore = store;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPasswordCrypt() {
            return this.myPasswordCrypt;
        }

        public void setPasswordCrypt(String passwordCrypt) {
            this.myPasswordCrypt = passwordCrypt;
        }
    }
}

