/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.BaseBusConnection;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.annotations.NotNull;

final class MessageBusConnectionImpl
extends BaseBusConnection
implements MessageBusConnection {
    private MessageHandler defaultHandler;

    MessageBusConnectionImpl(@NotNull MessageBusImpl bus) {
        super(bus);
    }

    public <L> void subscribe(@NotNull Topic<L> topic) throws IllegalStateException {
        MessageHandler defaultHandler = this.defaultHandler;
        if (defaultHandler == null) {
            throw new IllegalStateException("Connection must have default handler installed prior to any anonymous subscriptions. Target topic: " + topic);
        }
        if (topic.getListenerClass().isInstance(defaultHandler)) {
            throw new IllegalStateException("Can't subscribe to the topic '" + topic + "'. Default handler has incompatible type - expected: '" + topic.getListenerClass() + "', actual: '" + defaultHandler.getClass() + "'");
        }
        this.subscribe(topic, defaultHandler);
    }

    public void setDefaultHandler(MessageHandler handler) {
        this.defaultHandler = handler;
    }

    public void dispose() {
        MessageBusImpl bus = this.bus;
        if (bus == null) {
            return;
        }
        this.bus = null;
        this.defaultHandler = null;
        bus.notifyConnectionTerminated(this.subscriptions.getAndSet(ArrayUtilRt.EMPTY_OBJECT_ARRAY));
    }

    @Override
    public void disconnect() {
        Disposer.dispose((Disposable)this);
    }

    public void deliverImmediately() {
        this.bus.deliverImmediately(this);
    }

    static boolean removeHandlersFromJob(@NotNull Message job, Object[] topicAndHandlerPairs) {
        return job.handlers.removeIf(handler -> {
            for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
                if (job.topic != topicAndHandlerPairs[i] || handler != topicAndHandlerPairs[i + 1]) continue;
                return true;
            }
            return false;
        });
    }

    boolean isMyHandler(@NotNull Topic<?> topic, @NotNull Object handler) {
        if (this.defaultHandler == handler) {
            return true;
        }
        Object[] topicAndHandlerPairs = (Object[])this.subscriptions.get();
        int n = topicAndHandlerPairs.length;
        for (int i = 0; i < n; i += 2) {
            if (topic != topicAndHandlerPairs[i] || handler != topicAndHandlerPairs[i + 1]) continue;
            return true;
        }
        return false;
    }
}

