/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditSourceOnEnterKeyHandler {
    private static final KeyStroke ENTER = KeyStroke.getKeyStroke(10, 0);
    private static final KeyboardShortcut ENTER_SHORTCUT = new KeyboardShortcut(ENTER, null);

    public static void install(@NotNull JTree tree) {
        EditSourceOnEnterKeyHandler.install((JComponent)tree);
    }

    public static void install(@NotNull JComponent component) {
        EditSourceOnEnterKeyHandler.install(component, null);
    }

    public static void install(@NotNull JComponent component, @Nullable Runnable whenPerformed) {
        EditSourceOnEnterKeyHandler.install(component, whenPerformed, Registry.is((String)"edit.source.on.enter.key.request.focus.in.editor"));
    }

    private static void install(@NotNull JComponent component, @Nullable Runnable whenPerformed, boolean requestFocus) {
        EditSourceOnEnterKeyHandler.onEnterKey(component, () -> {
            if (Registry.is((String)"edit.source.on.enter.key.disabled")) {
                return false;
            }
            if (EditSourceOnEnterKeyHandler.isOverriddenByAction("EditSource")) {
                return false;
            }
            if (EditSourceOnEnterKeyHandler.isOverriddenByAction("ViewSource")) {
                return false;
            }
            DataContext context = DataManager.getInstance().getDataContext(component);
            List<Navigatable> navigatables = EditSourceOnEnterKeyHandler.getNavigatables(context);
            if (navigatables.isEmpty()) {
                return false;
            }
            navigatables.forEach(navigatable -> navigatable.navigate(requestFocus));
            if (whenPerformed != null) {
                whenPerformed.run();
            }
            return true;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isOverriddenByAction(@NotNull String actionId) {
        KeymapManager manager = KeymapManager.getInstance();
        if (manager == null) return false;
        if (null == ContainerUtil.find((Object[])manager.getActiveKeymap().getShortcuts(actionId), ENTER_SHORTCUT::equals)) return false;
        return true;
    }

    @NotNull
    private static List<Navigatable> getNavigatables(@NotNull DataContext context) {
        Object[] array = CommonDataKeys.NAVIGATABLE_ARRAY.getData(context);
        if (array == null || array.length == 0) {
            return Collections.emptyList();
        }
        List list = ContainerUtil.filter((Object[])array, Navigatable::canNavigateToSource);
        if (list.isEmpty() && Registry.is((String)"edit.source.on.enter.key.non.source.navigation.enabled")) {
            for (Object navigatable : array) {
                if (!navigatable.canNavigate()) continue;
                return Collections.singletonList(navigatable);
            }
        }
        return list;
    }

    private static void onEnterKey(@NotNull JComponent component, @NotNull BooleanSupplier action) {
        ActionListener listener2 = component.getActionForKeyStroke(ENTER);
        component.registerKeyboardAction(event -> {
            if (!action.getAsBoolean() && listener2 != null) {
                listener2.actionPerformed(event);
            }
        }, ENTER, 0);
    }
}

