/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import com.intellij.util.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private final ThreadLocal<Boolean> myIsProcessing = new ThreadLocal();
    private static final boolean RANDOMIZE = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();
    private static final Comparator<Object> CRAZY_ORDER = (o1, o2) -> -Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        ArrayList<Object> result = new ArrayList<Object>();
        Processor processor = Processors.cancelableCollectProcessor(result);
        this.forEach(processor);
        if (RANDOMIZE && result.size() > 1) {
            result.sort(CRAZY_ORDER);
        }
        return result;
    }

    @Override
    @NotNull
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator(this.findAll().iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach((Processor<? super Result>)processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (this.myIsProcessing.get() == null) : "Operation is not allowed while query is being processed";
    }

    @Override
    public Result @NotNull [] toArray(Result @NotNull [] a) {
        this.assertNotProcessing();
        Collection<Result> all = this.findAll();
        return all.toArray(a);
    }

    @Override
    @NotNull
    public Query<Result> allowParallelProcessing() {
        return new AbstractQuery<Result>(){

            @Override
            protected boolean processResults(@NotNull Processor<? super Result> consumer) {
                return AbstractQuery.this.doProcessResults(consumer);
            }
        };
    }

    @NotNull
    private Processor<Result> threadSafeProcessor(@NotNull Processor<? super Result> consumer) {
        Object lock = ObjectUtils.sentinel((String)"AbstractQuery lock");
        return e -> {
            Object object = lock;
            synchronized (object) {
                return consumer.process(e);
            }
        };
    }

    @Override
    public boolean forEach(@NotNull Processor<? super Result> consumer) {
        return this.doProcessResults(this.threadSafeProcessor(consumer));
    }

    private boolean doProcessResults(@NotNull Processor<? super Result> consumer) {
        this.assertNotProcessing();
        this.myIsProcessing.set(true);
        try {
            boolean bl = this.processResults(consumer);
            return bl;
        }
        finally {
            this.myIsProcessing.remove();
        }
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> forEachAsync(@NotNull Processor<? super Result> consumer) {
        return AsyncUtil.wrapBoolean(this.forEach(consumer));
    }

    protected abstract boolean processResults(@NotNull Processor<? super Result> var1);

    protected static <T> boolean delegateProcessResults(@NotNull Query<T> query, @NotNull Processor<? super T> consumer) {
        if (query instanceof AbstractQuery) {
            return ((AbstractQuery)query).doProcessResults(consumer);
        }
        return query.forEach(consumer);
    }

    @NotNull
    public static <T> Query<T> wrapInReadAction(final @NotNull Query<? extends T> query) {
        return new AbstractQuery<T>(){

            @Override
            protected boolean processResults(@NotNull Processor<? super T> consumer) {
                return AbstractQuery.delegateProcessResults(query, ReadActionProcessor.wrapInReadAction(consumer));
            }
        };
    }
}

