/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.usages.rules.UsageInFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirectoryStructureGroupingRule
implements DumbAware,
UsageGroupingRuleEx {
    protected final Project myProject;
    private final DirectoryGroupingRule myDirectoryGroupingRule;

    DirectoryStructureGroupingRule(@NotNull Project project) {
        this.myProject = project;
        this.myDirectoryGroupingRule = new DirectoryGroupingRule(project, false);
    }

    @Override
    @NotNull
    public List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        if (!(usage instanceof UsageInFile)) {
            return Collections.emptyList();
        }
        ArrayList<UsageGroup> result = new ArrayList<UsageGroup>();
        UsageInFile usageInFile = (UsageInFile)usage;
        VirtualFile file = usageInFile.getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        VirtualFile baseDir = ProjectUtil.guessProjectDir(this.myProject);
        for (VirtualFile dir = file.getParent(); dir != null && !dir.equals(baseDir); dir = dir.getParent()) {
            UsageGroup group = this.myDirectoryGroupingRule.getGroupForFile(dir);
            result.add(group);
        }
        Collections.reverse(result);
        return result;
    }

    @Override
    @Nullable
    public String getGroupingActionId() {
        return "UsageGrouping.DirectoryStructure";
    }
}

