/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.project.Project;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.FileStructureGroupRuleProvider;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.impl.rules.DirectoryStructureGroupingRule;
import com.intellij.usages.impl.rules.FileGroupingRule;
import com.intellij.usages.impl.rules.ModuleGroupingRule;
import com.intellij.usages.impl.rules.NonCodeUsageGroupingRule;
import com.intellij.usages.impl.rules.UsageScopeGroupingRule;
import com.intellij.usages.impl.rules.UsageTypeGroupingRule;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ActiveRules {
    public static UsageGroupingRule @NotNull [] getActiveRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings, boolean supportsNonCodeRule, boolean supportsScopesRule, boolean supportsModuleRule) {
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        if (supportsNonCodeRule) {
            rules.add(new NonCodeUsageGroupingRule(project));
        }
        if (supportsScopesRule && usageViewSettings.isGroupByScope()) {
            rules.add(new UsageScopeGroupingRule());
        }
        if (usageViewSettings.isGroupByUsageType()) {
            rules.add(new UsageTypeGroupingRule());
        }
        if (supportsModuleRule && usageViewSettings.isGroupByModule()) {
            rules.add(new ModuleGroupingRule(project, usageViewSettings.isFlattenModules()));
        }
        if (usageViewSettings.isGroupByPackage() && !usageViewSettings.isGroupByDirectoryStructure()) {
            rules.add(DirectoryGroupingRule.getInstance(project));
        }
        if (usageViewSettings.isGroupByDirectoryStructure()) {
            rules.add(new DirectoryStructureGroupingRule(project));
        }
        if (usageViewSettings.isGroupByFileStructure()) {
            for (FileStructureGroupRuleProvider ruleProvider : FileStructureGroupRuleProvider.EP_NAME.getExtensionList()) {
                ContainerUtil.addIfNotNull(rules, (Object)ruleProvider.getUsageGroupingRule(project, usageViewSettings));
            }
        } else {
            rules.add(new FileGroupingRule(project));
        }
        return rules.toArray(UsageGroupingRule.EMPTY_ARRAY);
    }

    public static UsageGroupingRule @NotNull [] getAllRules(@NotNull Project project, @NotNull UsageViewSettings usageViewSettings, boolean supportsNonCodeRule, boolean supportsScopesRule, boolean supportsModuleRule) {
        ArrayList<UsageGroupingRule> rules = new ArrayList<UsageGroupingRule>();
        if (supportsNonCodeRule) {
            rules.add(new NonCodeUsageGroupingRule(project));
        }
        if (supportsScopesRule) {
            rules.add(new UsageScopeGroupingRule());
        }
        rules.add(new UsageTypeGroupingRule());
        if (supportsModuleRule) {
            rules.add(new ModuleGroupingRule(project, usageViewSettings.isFlattenModules()));
        }
        rules.add(DirectoryGroupingRule.getInstance(project));
        rules.add(new DirectoryStructureGroupingRule(project));
        for (FileStructureGroupRuleProvider ruleProvider : FileStructureGroupRuleProvider.EP_NAME.getExtensionList()) {
            UsageGroupingRule rule = ruleProvider.getUsageGroupingRule(project, usageViewSettings);
            if (rule == null) continue;
            if (!(rule instanceof UsageGroupingRuleEx)) {
                rule = new FileStructureGroupingRuleExWrapper(rule);
            }
            rules.add(rule);
        }
        rules.add(new FileGroupingRule(project));
        return rules.toArray(UsageGroupingRule.EMPTY_ARRAY);
    }

    private static class FileStructureGroupingRuleExWrapper
    implements UsageGroupingRuleEx {
        private final UsageGroupingRule myGroupingRule;

        private FileStructureGroupingRuleExWrapper(@NotNull UsageGroupingRule rule) {
            this.myGroupingRule = rule;
        }

        @Override
        @NotNull
        public String getId() {
            return this.myGroupingRule.getClass().getName();
        }

        @Override
        @Nullable
        public String getGroupingActionId() {
            return "UsageGrouping.FileStructure";
        }

        @Override
        @NotNull
        public List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
            return this.myGroupingRule.getParentGroupsFor(usage, targets);
        }

        @Override
        public int getRank() {
            return this.myGroupingRule.getRank();
        }
    }
}

