/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ReadWriteAccessUsageInfo2UsageAdapter
extends UsageInfo2UsageAdapter
implements ReadWriteAccessUsage {
    private final byte initialRwLevel;
    private byte myRwLevel;

    public ReadWriteAccessUsageInfo2UsageAdapter(@NotNull UsageInfo usageInfo, boolean accessedForReading, boolean accessedForWriting) {
        super(usageInfo);
        this.initialRwLevel = this.myRwLevel = (byte)((accessedForReading ? 1 : 0) | (accessedForWriting ? 2 : 0));
        this.computeIcon();
    }

    private void computeIcon() {
        this.myIcon = RW.ICONS[this.myRwLevel];
    }

    @Override
    public boolean merge(@NotNull MergeableUsage other) {
        boolean merged = super.merge(other);
        if (merged && other instanceof ReadWriteAccessUsageInfo2UsageAdapter) {
            this.myRwLevel = (byte)(this.myRwLevel | ((ReadWriteAccessUsageInfo2UsageAdapter)other).myRwLevel);
            this.computeIcon();
        }
        return merged;
    }

    @Override
    public void reset() {
        super.reset();
        this.myRwLevel = this.initialRwLevel;
        this.computeIcon();
    }

    @Override
    public boolean isAccessedForWriting() {
        return BitUtil.isSet((int)this.myRwLevel, (int)2);
    }

    @Override
    public boolean isAccessedForReading() {
        return BitUtil.isSet((int)this.myRwLevel, (int)1);
    }

    private static class RW {
        private static final Icon[] ICONS = new Icon[]{PlatformIcons.VARIABLE_READ_ACCESS, PlatformIcons.VARIABLE_READ_ACCESS, PlatformIcons.VARIABLE_WRITE_ACCESS, PlatformIcons.VARIABLE_RW_ACCESS};

        private RW() {
        }
    }
}

