/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usages.NamedPresentably;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiElementUsageGroupBase<T extends PsiElement & NavigationItem>
implements UsageGroup,
NamedPresentably {
    private final SmartPsiElementPointer<T> myElementPointer;
    private final String myName;
    private final Icon myIcon;

    public PsiElementUsageGroupBase(@NotNull T element, Icon icon) {
        String myName = ((NavigationItem)element).getName();
        if (myName == null) {
            myName = "<anonymous>";
        }
        this.myName = myName;
        this.myElementPointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myIcon = icon;
    }

    public PsiElementUsageGroupBase(@NotNull T element) {
        this(element, element.getIcon(0));
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return this.myIcon;
    }

    public T getElement() {
        return this.myElementPointer.getElement();
    }

    @Override
    @NotNull
    public String getText(UsageView view) {
        return this.myName;
    }

    @Override
    public FileStatus getFileStatus() {
        return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)this.getElement()) : null;
    }

    @Override
    public boolean isValid() {
        T element = this.getElement();
        return element != null && element.isValid();
    }

    @Override
    public void navigate(boolean focus) throws UnsupportedOperationException {
        if (this.canNavigate()) {
            ((Navigatable)this.getElement()).navigate(focus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    public void update() {
    }

    @Override
    public int compareTo(@NotNull UsageGroup o) {
        String name = o instanceof NamedPresentably ? ((NamedPresentably)((Object)o)).getPresentableName() : o.getText(null);
        return this.myName.compareToIgnoreCase(name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PsiElementUsageGroupBase)) {
            return false;
        }
        PsiElementUsageGroupBase group = (PsiElementUsageGroupBase)obj;
        if (this.isValid() && group.isValid()) {
            return this.getElement().getManager().areElementsEquivalent((PsiElement)this.getElement(), (PsiElement)group.getElement());
        }
        return Objects.equals(this.myName, ((PsiElementUsageGroupBase)obj).myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myName;
    }
}

