/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.util.Function;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public interface TreeVisitor {
    @NotNull
    public Action visit(@NotNull TreePath var1);

    public static class ByTreePath<T>
    implements TreeVisitor {
        private final Function<TreePath, T> converter = currentPath -> converter.fun(currentPath.getLastPathComponent());
        private final boolean ignoreRoot;
        private final TreePath path;
        private final int count;

        public ByTreePath(@NotNull TreePath path2, @NotNull Function<Object, ? extends T> converter) {
            this(false, path2, converter);
        }

        public ByTreePath(boolean ignoreRoot, @NotNull TreePath path2, @NotNull Function<Object, ? extends T> converter) {
            this.ignoreRoot = ignoreRoot;
            this.path = path2;
            this.count = ignoreRoot ? path2.getPathCount() + 1 : path2.getPathCount();
        }

        @Override
        @NotNull
        public Action visit(@NotNull TreePath path2) {
            return this.ignoreRoot && null == path2.getParentPath() ? Action.CONTINUE : this.visit(path2, this.converter.fun((Object)path2));
        }

        @NotNull
        protected Action visit(@NotNull TreePath path2, T component) {
            if (component == null) {
                return Action.SKIP_CHILDREN;
            }
            int count = path2.getPathCount();
            if (count < this.count) {
                TreePath parent;
                for (parent = this.path.getParentPath(); ++count < this.count && parent != null; parent = parent.getParentPath()) {
                }
                boolean found = parent != null && this.matches(component, parent.getLastPathComponent());
                return !found ? Action.SKIP_CHILDREN : Action.CONTINUE;
            }
            boolean found = count > this.count || this.matches(component, this.path.getLastPathComponent());
            return !found ? Action.SKIP_CHILDREN : this.visit(path2, component, count - this.count);
        }

        @NotNull
        protected Action visit(@NotNull TreePath path2, @NotNull T component, int depth) {
            return depth == 0 ? Action.INTERRUPT : Action.SKIP_CHILDREN;
        }

        protected boolean matches(@NotNull T pathComponent, @NotNull Object thisComponent) {
            return pathComponent.equals(thisComponent);
        }
    }

    public static abstract class ByComponent<C, T>
    implements TreeVisitor {
        private final Function<TreePath, T> converter = currentPath -> converter.fun(currentPath.getLastPathComponent());
        private final C component;

        public ByComponent(@NotNull C component, @NotNull Function<Object, ? extends T> converter) {
            this.component = component;
        }

        public ByComponent(@NotNull C component, @NotNull Class<? extends T> type) {
            this(component, object -> type.isInstance(object) ? type.cast(object) : null);
        }

        @Override
        @NotNull
        public Action visit(@NotNull TreePath path2) {
            return this.visit(this.converter.fun((Object)path2));
        }

        @NotNull
        protected Action visit(T component) {
            if (component == null) {
                return Action.SKIP_CHILDREN;
            }
            if (this.matches(component, this.component)) {
                return Action.INTERRUPT;
            }
            if (this.contains(component, this.component)) {
                return Action.CONTINUE;
            }
            return Action.SKIP_CHILDREN;
        }

        protected boolean matches(@NotNull T pathComponent, @NotNull C thisComponent) {
            return pathComponent.equals(thisComponent);
        }

        protected abstract boolean contains(@NotNull T var1, @NotNull C var2);
    }

    public static interface Acceptor {
        @NotNull
        public Promise<TreePath> accept(@NotNull TreeVisitor var1);
    }

    public static enum Action {
        INTERRUPT,
        CONTINUE,
        SKIP_CHILDREN,
        SKIP_SIBLINGS;

    }
}

