/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking;

import com.intellij.openapi.Disposable;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockableContent;
import java.awt.Image;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DockContainer {
    @NotNull
    public RelativeRectangle getAcceptArea();

    @NotNull
    default public RelativeRectangle getAcceptAreaFallback() {
        return this.getAcceptArea();
    }

    @NotNull
    public ContentResponse getContentResponse(@NotNull DockableContent<?> var1, RelativePoint var2);

    public JComponent getContainerComponent();

    public void add(@NotNull DockableContent<?> var1, RelativePoint var2);

    default public void closeAll() {
    }

    default public void addListener(@NotNull Listener listener2, Disposable parent) {
    }

    public boolean isEmpty();

    @Nullable
    default public Image startDropOver(@NotNull DockableContent<?> content, RelativePoint point) {
        return null;
    }

    @Nullable
    default public Image processDropOver(@NotNull DockableContent<?> content, RelativePoint point) {
        return null;
    }

    default public void resetDropOver(@NotNull DockableContent<?> content) {
    }

    public boolean isDisposeWhenEmpty();

    public static interface Listener {
        default public void contentAdded(@NotNull Object key) {
        }

        default public void contentRemoved(Object key) {
        }
    }

    public static interface Persistent
    extends DockContainer {
        public String getDockContainerType();

        public Element getState();
    }

    public static interface Dialog
    extends DockContainer {
    }

    public static enum ContentResponse {
        ACCEPT_MOVE,
        ACCEPT_COPY,
        DENY;


        public boolean canAccept() {
            return this != DENY;
        }
    }
}

