/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBLoadingPanel
extends JPanel {
    private final JPanel myPanel;
    final LoadingDecorator myDecorator;
    private final Collection<JBLoadingPanelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull Disposable parent) {
        this(manager, parent, -1);
    }

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull Disposable parent, int startDelayMs) {
        this(manager, (NotNullFunction<? super JPanel, ? extends LoadingDecorator>)((NotNullFunction)panel2 -> new LoadingDecorator((JComponent)panel2, parent, startDelayMs){

            @Override
            protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
                NonOpaquePanel panel2 = super.customizeLoadingLayer(parent, text, icon);
                JBLoadingPanel.customizeStatusText(text);
                return panel2;
            }
        }));
    }

    public JBLoadingPanel(@Nullable LayoutManager manager, @NotNull NotNullFunction<? super JPanel, ? extends LoadingDecorator> createLoadingDecorator) {
        super(new BorderLayout());
        this.myPanel = manager == null ? new JPanel() : new JPanel(manager);
        this.myPanel.setOpaque(false);
        this.myPanel.setFocusable(false);
        this.myDecorator = (LoadingDecorator)createLoadingDecorator.fun((Object)this.myPanel);
        super.add((Component)this.myDecorator.getComponent(), "Center");
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (!(mgr instanceof BorderLayout)) {
            throw new IllegalArgumentException(String.valueOf(mgr));
        }
        super.setLayout(mgr);
        if (this.myDecorator != null) {
            super.add((Component)this.myDecorator.getComponent(), "Center");
        }
    }

    public static void customizeStatusText(JLabel text) {
        Font font = text.getFont();
        text.setFont(font.deriveFont(font.getStyle(), font.getSize() + 6));
        text.setForeground(ColorUtil.toAlpha((Color)UIUtil.getLabelForeground(), (int)150));
    }

    public void setLoadingText(String text) {
        this.myDecorator.setLoadingText(text);
    }

    public void stopLoading() {
        this.myDecorator.stopLoading();
        for (JBLoadingPanelListener listener2 : this.myListeners) {
            listener2.onLoadingFinish();
        }
    }

    public boolean isLoading() {
        return this.myDecorator.isLoading();
    }

    public void startLoading() {
        this.myDecorator.startLoading(false);
        for (JBLoadingPanelListener listener2 : this.myListeners) {
            listener2.onLoadingStart();
        }
    }

    public void addListener(@NotNull JBLoadingPanelListener listener2) {
        this.myListeners.add(listener2);
    }

    public boolean removeListener(@NotNull JBLoadingPanelListener listener2) {
        return this.myListeners.remove(listener2);
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    @Override
    public Component add(Component comp) {
        return this.myPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.myPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.myPanel.add(comp, constraints);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getContentPanel().getPreferredSize();
    }
}

