/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListToolbarDecorator;
import com.intellij.ui.TableToolbarDecorator;
import com.intellij.ui.TreeToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolbarDecorator
implements CommonActionsPanel.ListenerFactory {
    protected Border myPanelBorder;
    protected Border myToolbarBorder;
    protected Border myScrollPaneBorder;
    protected boolean myAddActionEnabled;
    protected boolean myEditActionEnabled;
    protected boolean myRemoveActionEnabled;
    protected boolean myUpActionEnabled;
    protected boolean myDownActionEnabled;
    private final List<AnActionButton> myExtraActions = new SmartList();
    private ActionToolbarPosition myToolbarPosition;
    protected AnActionButtonRunnable myAddAction;
    protected AnActionButtonRunnable myEditAction;
    protected AnActionButtonRunnable myRemoveAction;
    protected AnActionButtonRunnable myUpAction;
    protected AnActionButtonRunnable myDownAction;
    private String myAddName;
    private String myEditName;
    private String myRemoveName;
    private String myMoveUpName;
    private String myMoveDownName;
    private AnActionButtonUpdater myAddActionUpdater;
    private AnActionButtonUpdater myRemoveActionUpdater;
    private AnActionButtonUpdater myEditActionUpdater;
    private AnActionButtonUpdater myMoveUpActionUpdater;
    private AnActionButtonUpdater myMoveDownActionUpdater;
    private Dimension myPreferredSize;
    private Dimension myMinimumSize;
    private CommonActionsPanel myActionsPanel;
    private Comparator<? super AnActionButton> myButtonComparator;
    private Icon myAddIcon;
    private boolean myForcedDnD;

    @NotNull
    protected abstract JComponent getComponent();

    protected abstract void updateButtons();

    protected void updateExtraElementActions(boolean someElementSelected) {
        for (AnActionButton action : this.myExtraActions) {
            if (!(action instanceof ElementActionButton)) continue;
            action.setEnabled(someElementSelected);
        }
    }

    public final CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    @NotNull
    public ToolbarDecorator initPosition() {
        this.setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.RIGHT);
        return this;
    }

    @Deprecated
    public ToolbarDecorator setAsUsualTopToolbar() {
        return this.setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty());
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JTable table) {
        return new TableToolbarDecorator(table, null).initPosition();
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JTree tree) {
        return ToolbarDecorator.createDecorator(tree, null);
    }

    @NotNull
    private static ToolbarDecorator createDecorator(@NotNull JTree tree, @Nullable ElementProducer<?> producer) {
        return new TreeToolbarDecorator(tree, producer).initPosition();
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull JList<T> list) {
        return new ListToolbarDecorator<T>(list, null).initPosition();
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull JList<T> list, EditableModel editableModel) {
        return new ListToolbarDecorator<T>(list, editableModel).initPosition();
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull TableView<T> table, @Nullable ElementProducer<T> producer) {
        return new TableToolbarDecorator(table, producer).initPosition();
    }

    @NotNull
    public ToolbarDecorator disableAddAction() {
        return this.setAddAction(null);
    }

    @NotNull
    public ToolbarDecorator disableRemoveAction() {
        return this.setRemoveAction(null);
    }

    @NotNull
    public ToolbarDecorator disableUpAction() {
        return this.setMoveUpAction(null);
    }

    @NotNull
    public ToolbarDecorator disableUpDownActions() {
        this.disableUpAction();
        return this.disableDownAction();
    }

    @NotNull
    public ToolbarDecorator disableDownAction() {
        return this.setMoveDownAction(null);
    }

    @NotNull
    public ToolbarDecorator setPanelBorder(Border border) {
        this.myPanelBorder = border;
        return this;
    }

    @NotNull
    public ToolbarDecorator setToolbarBorder(Border border) {
        this.myToolbarBorder = border;
        return this;
    }

    @NotNull
    public ToolbarDecorator setScrollPaneBorder(Border border) {
        this.myScrollPaneBorder = border;
        return this;
    }

    @NotNull
    public ToolbarDecorator setButtonComparator(Comparator<? super AnActionButton> buttonComparator) {
        this.myButtonComparator = buttonComparator;
        return this;
    }

    @NotNull
    public ToolbarDecorator setButtonComparator(String ... actionNames) {
        List<String> names = Arrays.asList(actionNames);
        this.myButtonComparator = (o1, o2) -> {
            String t1 = o1.getTemplatePresentation().getText();
            String t2 = o2.getTemplatePresentation().getText();
            if (t1 == null || t2 == null) {
                return 0;
            }
            int ind1 = names.indexOf(t1);
            int ind2 = names.indexOf(t2);
            if (ind1 == -1 && ind2 >= 0) {
                return 1;
            }
            if (ind2 == -1 && ind1 >= 0) {
                return -1;
            }
            return ind1 - ind2;
        };
        return this;
    }

    @NotNull
    public ToolbarDecorator addExtraAction(@NotNull AnActionButton action) {
        this.myExtraActions.add(action);
        return this;
    }

    @NotNull
    public ToolbarDecorator addExtraActions(AnActionButton ... actions) {
        for (AnActionButton action : actions) {
            if (action == null) continue;
            this.addExtraAction(action);
        }
        return this;
    }

    @NotNull
    public ToolbarDecorator setToolbarPosition(ActionToolbarPosition position) {
        this.myToolbarPosition = position;
        return this;
    }

    @NotNull
    public ToolbarDecorator setAddAction(AnActionButtonRunnable action) {
        this.myAddActionEnabled = action != null;
        this.myAddAction = action;
        return this;
    }

    @NotNull
    public ToolbarDecorator setEditAction(AnActionButtonRunnable action) {
        this.myEditActionEnabled = action != null;
        this.myEditAction = action;
        return this;
    }

    @NotNull
    public ToolbarDecorator setRemoveAction(AnActionButtonRunnable action) {
        this.myRemoveActionEnabled = action != null;
        this.myRemoveAction = action;
        return this;
    }

    @NotNull
    public ToolbarDecorator setMoveUpAction(AnActionButtonRunnable action) {
        this.myUpActionEnabled = action != null;
        this.myUpAction = action;
        return this;
    }

    @NotNull
    public ToolbarDecorator setMoveDownAction(AnActionButtonRunnable action) {
        this.myDownActionEnabled = action != null;
        this.myDownAction = action;
        return this;
    }

    @NotNull
    public ToolbarDecorator setAddActionName(@NlsActions.ActionText String name) {
        this.myAddName = name;
        return this;
    }

    @NotNull
    public ToolbarDecorator setEditActionName(@NlsActions.ActionText String name) {
        this.myEditName = name;
        return this;
    }

    @NotNull
    public ToolbarDecorator setRemoveActionName(@NlsActions.ActionText String name) {
        this.myRemoveName = name;
        return this;
    }

    @NotNull
    public ToolbarDecorator setMoveUpActionName(@NlsActions.ActionText String name) {
        this.myMoveUpName = name;
        return this;
    }

    @NotNull
    public ToolbarDecorator setMoveDownActionName(@NlsActions.ActionText String name) {
        this.myMoveDownName = name;
        return this;
    }

    @NotNull
    public ToolbarDecorator setAddActionUpdater(AnActionButtonUpdater updater) {
        this.myAddActionUpdater = updater;
        return this;
    }

    @NotNull
    public ToolbarDecorator setRemoveActionUpdater(AnActionButtonUpdater updater) {
        this.myRemoveActionUpdater = updater;
        return this;
    }

    @NotNull
    public ToolbarDecorator setEditActionUpdater(AnActionButtonUpdater updater) {
        this.myEditActionUpdater = updater;
        return this;
    }

    @NotNull
    public ToolbarDecorator setMoveUpActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveUpActionUpdater = updater;
        return this;
    }

    @NotNull
    public ToolbarDecorator setMoveDownActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveDownActionUpdater = updater;
        return this;
    }

    @NotNull
    public ToolbarDecorator setForcedDnD() {
        this.myForcedDnD = true;
        return this;
    }

    @NotNull
    public ToolbarDecorator setActionGroup(@NotNull ActionGroup actionGroup) {
        AnAction[] actions;
        for (AnAction action : actions = actionGroup.getChildren(null)) {
            if (action instanceof Separator) continue;
            this.addExtraAction(AnActionButton.fromAction(action));
        }
        return this;
    }

    @NotNull
    public ToolbarDecorator setPreferredSize(Dimension size) {
        this.myPreferredSize = size;
        return this;
    }

    @NotNull
    public ToolbarDecorator setMinimumSize(Dimension size) {
        this.myMinimumSize = size;
        return this;
    }

    @NotNull
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        return this;
    }

    @NotNull
    public ToolbarDecorator setAddIcon(Icon addIcon) {
        this.myAddIcon = addIcon;
        return this;
    }

    @NotNull
    public JPanel createPanel() {
        CommonActionsPanel.Buttons[] buttons = this.getButtons();
        JComponent contextComponent = this.getComponent();
        UIUtil.putClientProperty((JComponent)contextComponent, JBViewport.FORCE_VISIBLE_ROW_COUNT_KEY, (Object)true);
        this.myActionsPanel = new CommonActionsPanel(this, contextComponent, this.myToolbarPosition, this.myExtraActions.toArray(new AnActionButton[0]), this.myButtonComparator, this.myAddName, this.myRemoveName, this.myMoveUpName, this.myMoveDownName, this.myEditName, this.myAddIcon, buttons);
        JBScrollPane scrollPane = new JBScrollPane(contextComponent){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                if (!this.isPreferredSizeSet()) {
                    this.setPreferredSize(new Dimension(0, preferredSize.height));
                }
                return preferredSize;
            }
        };
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        if (this.myPreferredSize != null) {
            scrollPane.setPreferredSize(this.myPreferredSize);
        }
        if (this.myMinimumSize != null) {
            scrollPane.setMinimumSize(this.myMinimumSize);
        }
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                ToolbarDecorator.this.updateButtons();
            }
        };
        panel2.add((Component)scrollPane, "Center");
        panel2.add((Component)this.myActionsPanel, ToolbarDecorator.getPlacement(this.myToolbarPosition));
        this.installUpdaters();
        this.updateButtons();
        this.installDnD();
        panel2.putClientProperty("ACTION_TOOLBAR", this.myActionsPanel.getComponent(0));
        panel2.setBorder(this.myPanelBorder != null ? this.myPanelBorder : IdeBorderFactory.createBorder(15));
        if (this.myScrollPaneBorder != null || this.myPanelBorder instanceof EmptyBorder) {
            scrollPane.setBorder(this.myScrollPaneBorder != null ? this.myScrollPaneBorder : IdeBorderFactory.createBorder(15));
        }
        if ((this.myToolbarBorder == null || this.myToolbarBorder instanceof EmptyBorder) && scrollPane.getBorder() == null || scrollPane.getBorder() instanceof EmptyBorder) {
            this.myToolbarBorder = new CustomLineBorder(this.myToolbarPosition == ActionToolbarPosition.BOTTOM ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.RIGHT ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.TOP ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.LEFT ? 1 : 0);
        }
        this.myActionsPanel.setBorder(this.myToolbarBorder != null ? this.myToolbarBorder : JBUI.Borders.empty());
        return panel2;
    }

    private void installUpdaters() {
        if (this.myAddActionEnabled && this.myAddAction != null && this.myAddActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.ADD).addCustomUpdater(this.myAddActionUpdater);
        }
        if (this.myEditActionEnabled && this.myEditAction != null && this.myEditActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.EDIT).addCustomUpdater(this.myEditActionUpdater);
        }
        if (this.myRemoveActionEnabled && this.myRemoveAction != null && this.myRemoveActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.REMOVE).addCustomUpdater(this.myRemoveActionUpdater);
        }
        if (this.myUpActionEnabled && this.myUpAction != null && this.myMoveUpActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.UP).addCustomUpdater(this.myMoveUpActionUpdater);
        }
        if (this.myDownActionEnabled && this.myDownAction != null && this.myMoveDownActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.DOWN).addCustomUpdater(this.myMoveDownActionUpdater);
        }
    }

    protected void installDnD() {
        if ((this.myForcedDnD || this.myUpAction != null && this.myUpActionEnabled && this.myDownAction != null && this.myDownActionEnabled) && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.isModelEditable()) {
            this.installDnDSupport();
        }
    }

    protected abstract void installDnDSupport();

    protected abstract boolean isModelEditable();

    @NotNull
    static Object getPlacement(@NotNull ActionToolbarPosition position) {
        switch (position) {
            case TOP: {
                return "North";
            }
            case LEFT: {
                return "West";
            }
            case BOTTOM: {
                return "South";
            }
            case RIGHT: {
                return "East";
            }
        }
        return "South";
    }

    private CommonActionsPanel.Buttons @NotNull [] getButtons() {
        ArrayList<CommonActionsPanel.Buttons> buttons = new ArrayList<CommonActionsPanel.Buttons>();
        HashMap<CommonActionsPanel.Buttons, Pair> map = new HashMap<CommonActionsPanel.Buttons, Pair>();
        map.put(CommonActionsPanel.Buttons.ADD, Pair.create((Object)this.myAddActionEnabled, (Object)this.myAddAction));
        map.put(CommonActionsPanel.Buttons.REMOVE, Pair.create((Object)this.myRemoveActionEnabled, (Object)this.myRemoveAction));
        map.put(CommonActionsPanel.Buttons.EDIT, Pair.create((Object)this.myEditActionEnabled, (Object)this.myEditAction));
        map.put(CommonActionsPanel.Buttons.UP, Pair.create((Object)this.myUpActionEnabled, (Object)this.myUpAction));
        map.put(CommonActionsPanel.Buttons.DOWN, Pair.create((Object)this.myDownActionEnabled, (Object)this.myDownAction));
        for (CommonActionsPanel.Buttons button : CommonActionsPanel.Buttons.values()) {
            Pair action = (Pair)map.get((Object)button);
            if (action == null || action.first == null || !((Boolean)action.first).booleanValue() || action.second == null) continue;
            buttons.add(button);
        }
        return buttons.toArray(new CommonActionsPanel.Buttons[0]);
    }

    @Override
    @NotNull
    public CommonActionsPanel.Listener createListener(final @NotNull CommonActionsPanel panel2) {
        return new CommonActionsPanel.Listener(){

            @Override
            public void doAdd() {
                if (ToolbarDecorator.this.myAddAction != null) {
                    ToolbarDecorator.this.myAddAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.ADD));
                }
            }

            @Override
            public void doEdit() {
                if (ToolbarDecorator.this.myEditAction != null) {
                    ToolbarDecorator.this.myEditAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.EDIT));
                }
            }

            @Override
            public void doRemove() {
                if (ToolbarDecorator.this.myRemoveAction != null) {
                    ToolbarDecorator.this.myRemoveAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.REMOVE));
                }
            }

            @Override
            public void doUp() {
                if (ToolbarDecorator.this.myUpAction != null) {
                    ToolbarDecorator.this.myUpAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.UP));
                }
            }

            @Override
            public void doDown() {
                if (ToolbarDecorator.this.myDownAction != null) {
                    ToolbarDecorator.this.myDownAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.DOWN));
                }
            }
        };
    }

    @Nullable
    public static AnActionButton findAddButton(@NotNull JComponent container) {
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.ADD);
    }

    @Nullable
    public static AnActionButton findEditButton(@NotNull JComponent container) {
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.EDIT);
    }

    @Nullable
    public static AnActionButton findRemoveButton(@NotNull JComponent container) {
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.REMOVE);
    }

    @Nullable
    public static AnActionButton findUpButton(@NotNull JComponent container) {
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.UP);
    }

    @Nullable
    public static AnActionButton findDownButton(@NotNull JComponent container) {
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.DOWN);
    }

    @Nullable
    private static AnActionButton findButton(JComponent comp, CommonActionsPanel.Buttons type) {
        CommonActionsPanel panel2 = (CommonActionsPanel)UIUtil.findComponentOfType((JComponent)comp, CommonActionsPanel.class);
        if (panel2 != null) {
            return panel2.getAnActionButton(type);
        }
        return null;
    }

    public static abstract class ElementActionButton
    extends AnActionButton {
        public ElementActionButton(@NlsContexts.Button String text, @NlsContexts.Tooltip String description, @Nullable Icon icon) {
            super(text, description, icon);
        }

        public ElementActionButton(@NlsContexts.Button String text, Icon icon) {
            super(text, icon);
        }

        public ElementActionButton() {
        }

        public ElementActionButton(@NlsContexts.Button String text) {
            super(text);
        }
    }
}

