/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MouseDragHelper
extends MouseAdapter
implements MouseMotionListener,
KeyEventDispatcher,
Weighted {
    public static final int DRAG_START_DEADZONE = 7;
    @NotNull
    private final JComponent myDragComponent;
    private Point myPressPointScreen;
    protected Point myPressedOnScreenPoint;
    private boolean myDraggingNow;
    private boolean myDragJustStarted;
    private IdeGlassPane myGlassPane;
    @NotNull
    private final Disposable myParentDisposable;
    private Dimension myDelta;
    private boolean myDetachPostponed;
    private boolean myDetachingMode;
    private boolean myCancelled;
    private Disposable myGlassPaneListenersDisposable = Disposer.newDisposable();
    private boolean myStopped;

    public MouseDragHelper(@NotNull Disposable parent, @NotNull JComponent dragComponent) {
        this.myDragComponent = dragComponent;
        this.myParentDisposable = parent;
    }

    public static boolean checkModifiers(@Nullable InputEvent event) {
        if (event == null || !UISettings.getInstance().getDndWithPressedAltOnly()) {
            return true;
        }
        return (event.getModifiers() & 8) != 0;
    }

    public void start() {
        if (this.myGlassPane != null) {
            return;
        }
        new UiNotifyConnector(this.myDragComponent, new Activatable(){

            @Override
            public void showNotify() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(MouseDragHelper.this);
                MouseDragHelper.this.attach();
            }

            @Override
            public void hideNotify() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(MouseDragHelper.this);
                MouseDragHelper.this.detach(true);
            }
        });
        Disposer.register((Disposable)this.myParentDisposable, () -> this.stop());
    }

    private void attach() {
        if (this.myDetachPostponed) {
            this.myDetachPostponed = false;
            return;
        }
        if (this.myStopped) {
            return;
        }
        this.myGlassPane = IdeGlassPaneUtil.find(this.myDragComponent);
        this.myGlassPaneListenersDisposable = Disposer.newDisposable((String)"myGlassPaneListeners");
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myGlassPaneListenersDisposable);
        this.myGlassPane.addMousePreprocessor(this, this.myGlassPaneListenersDisposable);
        this.myGlassPane.addMouseMotionPreprocessor(this, this.myGlassPaneListenersDisposable);
    }

    public void stop() {
        this.myStopped = true;
        this.detach(false);
    }

    private void detach(boolean canPostponeDetach) {
        if (canPostponeDetach && this.myDraggingNow) {
            this.myDetachPostponed = true;
            return;
        }
        if (this.myGlassPane != null) {
            Disposer.dispose((Disposable)this.myGlassPaneListenersDisposable);
            this.myGlassPaneListenersDisposable = Disposer.newDisposable();
            this.myGlassPane = null;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public double getWeight() {
        return 2.0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.canStartDragging(e)) {
            return;
        }
        this.myPressPointScreen = new RelativePoint(e).getScreenPoint();
        this.myPressedOnScreenPoint = new Point(this.myPressPointScreen);
        this.processMousePressed(e);
        this.myDelta = new Dimension();
        if (this.myDragComponent.isShowing()) {
            Point delta = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.myDragComponent);
            this.myDelta.width = delta.x;
            this.myDelta.height = delta.y;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.myCancelled) {
            this.myCancelled = false;
            return;
        }
        boolean wasDragging = this.myDraggingNow;
        this.myPressPointScreen = null;
        this.myDraggingNow = false;
        this.myDragJustStarted = false;
        if (wasDragging) {
            try {
                if (this.myDetachingMode) {
                    this.processDragOutFinish(e);
                } else {
                    this.processDragFinish(e, false);
                }
            }
            finally {
                this.myPressedOnScreenPoint = null;
                this.resetDragState();
                e.consume();
                if (this.myDetachPostponed) {
                    this.myDetachPostponed = false;
                    this.detach(false);
                }
            }
        }
    }

    private void resetDragState() {
        this.myDraggingNow = false;
        this.myDragJustStarted = false;
        this.myPressPointScreen = null;
        this.myDetachingMode = false;
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        if (this.myPressPointScreen == null || this.myCancelled) {
            return;
        }
        boolean deadZone = this.isWithinDeadZone(e);
        if (!this.myDraggingNow && !deadZone) {
            this.myDraggingNow = true;
            this.myDragJustStarted = true;
        } else if (this.myDraggingNow) {
            this.myDragJustStarted = false;
        }
        if (this.myDraggingNow && this.myPressPointScreen != null) {
            Point draggedTo = new RelativePoint(e).getScreenPoint();
            boolean dragOutStarted = false;
            if (!this.myDetachingMode && this.isDragOut(e, draggedTo, (Point)this.myPressPointScreen.clone())) {
                this.myDetachingMode = true;
                this.processDragFinish(e, true);
                dragOutStarted = true;
            }
            if (this.myDetachingMode) {
                this.processDragOut(e, draggedTo, (Point)this.myPressPointScreen.clone(), dragOutStarted);
            } else {
                this.processDrag(e, draggedTo, (Point)this.myPressPointScreen.clone());
            }
        }
    }

    private boolean canStartDragging(@NotNull MouseEvent me) {
        if (me.getButton() != 1) {
            return false;
        }
        if (!this.myDragComponent.isShowing()) {
            return false;
        }
        Component component = me.getComponent();
        if (NullableComponent.Check.isNullOrHidden((Component)component)) {
            return false;
        }
        Point dragComponentPoint = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), this.myDragComponent);
        return this.canStartDragging(this.myDragComponent, dragComponentPoint);
    }

    protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
        return true;
    }

    protected void processMousePressed(@NotNull MouseEvent event) {
    }

    protected void processDragCancel() {
    }

    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
    }

    protected void processDragOutFinish(@NotNull MouseEvent event) {
    }

    protected void processDragOutCancel() {
    }

    protected final boolean isDragJustStarted() {
        return this.myDragJustStarted;
    }

    protected abstract void processDrag(@NotNull MouseEvent var1, @NotNull Point var2, @NotNull Point var3);

    protected boolean isDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        return false;
    }

    protected void processDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint, boolean justStarted) {
        event.consume();
    }

    private boolean isWithinDeadZone(@NotNull MouseEvent e) {
        Point screen = new RelativePoint(e).getScreenPoint();
        return Math.abs(this.myPressPointScreen.x - screen.x - this.myDelta.width) < 7 && Math.abs(this.myPressPointScreen.y - screen.y - this.myDelta.height) < 7;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
    }

    @Override
    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        if (e.getKeyCode() == 27 && e.getID() == 401 && this.myDraggingNow) {
            this.myCancelled = true;
            if (this.myDetachingMode) {
                this.processDragOutCancel();
            } else {
                this.processDragCancel();
            }
            this.resetDragState();
            return true;
        }
        return false;
    }
}

