/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class ListCellRendererWrapper<T>
implements ListCellRenderer<T> {
    private final ListCellRenderer<? super T> myRenderer;
    private boolean mySeparator;
    private Icon myIcon;
    private String myText;
    private String myToolTipText;
    private Color myForeground;
    private Color myBackground;
    private Font myFont;
    private FList<Pair<Object, Object>> myProperties = FList.emptyList();

    public ListCellRendererWrapper() {
        this.myRenderer = new JComboBox().getRenderer();
    }

    @Override
    public final Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
        JBLabel component;
        this.mySeparator = false;
        this.myIcon = null;
        this.myText = null;
        this.myForeground = null;
        this.myBackground = null;
        this.myFont = null;
        this.myToolTipText = null;
        this.myProperties = FList.emptyList();
        this.customize(list, value, index, selected, hasFocus);
        if (this.mySeparator) {
            return ListCellRendererWrapper.createSeparator(this.myText);
        }
        Component component2 = component = this.myRenderer != null ? this.myRenderer.getListCellRendererComponent(list, value, index, selected, hasFocus) : new JBLabel();
        if (component instanceof JLabel) {
            JLabel label = component;
            label.setIcon(this.myIcon);
            if (this.myText != null) {
                label.setText(this.myText);
            }
            if (this.myForeground != null) {
                label.setForeground(this.myForeground);
            }
            if (this.myBackground != null && !selected) {
                label.setBackground(this.myBackground);
            }
            if (this.myFont != null) {
                label.setFont(this.myFont);
            }
            label.setToolTipText(this.myToolTipText);
            for (Pair pair : this.myProperties) {
                label.putClientProperty(pair.first, pair.second);
            }
        }
        return component;
    }

    @Deprecated
    @NotNull
    public static Component createSeparator(@Nullable String text) {
        TitledSeparator separator = new TitledSeparator(text);
        separator.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        separator.setOpaque(false);
        separator.setBackground(UIUtil.TRANSPARENT_COLOR);
        separator.getLabel().setOpaque(false);
        separator.getLabel().setBackground(UIUtil.TRANSPARENT_COLOR);
        return separator;
    }

    public abstract void customize(JList var1, T var2, int var3, boolean var4, boolean var5);

    public final void setSeparator() {
        this.mySeparator = true;
    }

    public final void setIcon(@Nullable Icon icon) {
        this.myIcon = icon;
    }

    public final void setText(@Nullable String text) {
        this.myText = text;
    }

    public final void setToolTipText(@Nullable String toolTipText) {
        this.myToolTipText = toolTipText;
    }

    public final void setForeground(@Nullable Color foreground) {
        this.myForeground = foreground;
    }

    public final void setBackground(@Nullable Color background) {
        this.myBackground = background;
    }

    public final void setFont(@Nullable Font font) {
        this.myFont = font;
    }

    public final void setClientProperty(@NotNull Object key, @Nullable Object value) {
        this.myProperties = this.myProperties.prepend((Object)Pair.pair((Object)key, (Object)value));
    }
}

