/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonActionsPanel
extends JPanel {
    private final ActionToolbarPosition myPosition;
    private final ActionToolbar myToolbar;
    private final Map<Buttons, AnActionButton> myButtons = new HashMap<Buttons, AnActionButton>();
    private final AnActionButton[] myActions;
    private EnumMap<Buttons, ShortcutSet> myCustomShortcuts;

    CommonActionsPanel(@NotNull ListenerFactory factory, @Nullable JComponent contextComponent, ActionToolbarPosition position, AnActionButton @Nullable [] additionalActions, @Nullable Comparator<? super AnActionButton> buttonComparator, String addName, String removeName, String moveUpName, String moveDownName, String editName, Icon addIcon, Buttons ... buttons) {
        super(new BorderLayout());
        int i;
        this.myPosition = position;
        Listener listener2 = factory.createListener(this);
        AnActionButton[] actions = new AnActionButton[buttons.length + (additionalActions == null ? 0 : additionalActions.length)];
        for (i = 0; i < buttons.length; ++i) {
            AnActionButton b;
            AnActionButton[] button = buttons[i];
            String name = null;
            switch (2.$SwitchMap$com$intellij$ui$CommonActionsPanel$Buttons[button.ordinal()]) {
                case 1: {
                    name = addName;
                    break;
                }
                case 2: {
                    name = editName;
                    break;
                }
                case 3: {
                    name = removeName;
                    break;
                }
                case 4: {
                    name = moveUpName;
                    break;
                }
                case 5: {
                    name = moveDownName;
                }
            }
            actions[i] = b = button.createButton(listener2, name, button == Buttons.ADD && addIcon != null ? addIcon : button.getIcon());
            this.myButtons.put((Buttons)button, b);
        }
        if (additionalActions != null && additionalActions.length > 0) {
            i = buttons.length;
            for (AnActionButton button : additionalActions) {
                actions[i++] = button;
            }
        }
        this.myActions = actions;
        for (AnActionButton action : actions) {
            action.setContextComponent(contextComponent);
        }
        if (buttonComparator != null) {
            Arrays.sort(this.myActions, buttonComparator);
        }
        ArrayList toolbarActions = ContainerUtil.newArrayList((Object[])this.myActions);
        for (int i2 = 0; i2 < toolbarActions.size(); ++i2) {
            if (!(toolbarActions.get(i2) instanceof AnActionButton.CheckedAnActionButton)) continue;
            toolbarActions.set(i2, ((AnActionButton.CheckedAnActionButton)toolbarActions.get(i2)).getDelegate());
        }
        ActionManagerEx mgr = (ActionManagerEx)ActionManager.getInstance();
        this.myToolbar = mgr.createActionToolbar("ToolbarDecorator", new DefaultActionGroup(toolbarActions.toArray(AnAction.EMPTY_ARRAY)), position == ActionToolbarPosition.BOTTOM || position == ActionToolbarPosition.TOP);
        this.myToolbar.getComponent().setBorder(null);
        this.add((Component)this.myToolbar.getComponent(), "Center");
    }

    @NotNull
    public ActionToolbar getToolbar() {
        return this.myToolbar;
    }

    public void setToolbarLabel(JComponent label, ActionToolbarPosition position) {
        this.removeAll();
        this.add((Component)label, ToolbarDecorator.getPlacement(position));
        if (position == ActionToolbarPosition.LEFT) {
            this.add((Component)this.myToolbar.getComponent(), "East");
        } else if (position == ActionToolbarPosition.RIGHT) {
            this.add((Component)this.myToolbar.getComponent(), "West");
        } else {
            this.add((Component)this.myToolbar.getComponent(), "Center");
        }
    }

    public AnActionButton getAnActionButton(Buttons button) {
        return this.myButtons.get((Object)button);
    }

    @Override
    public void addNotify() {
        if (this.getBackground() != null && !this.getBackground().equals(UIUtil.getPanelBackground())) {
            SwingUtilities.updateComponentTreeUI(this.getParent());
        }
        JRootPane pane = this.getRootPane();
        for (AnActionButton button : this.myActions) {
            ShortcutSet customShortCut;
            ShortcutSet shortcut = button.getShortcut();
            if (shortcut == null) continue;
            if (button instanceof MyActionButton && this.myCustomShortcuts != null && (customShortCut = this.myCustomShortcuts.get((Object)((MyActionButton)button).myButton)) != null) {
                shortcut = customShortCut;
            }
            if (button instanceof AddButton && UIUtil.isDialogRootPane((JRootPane)pane)) {
                button.registerCustomShortcutSet(shortcut, pane);
            } else {
                button.registerCustomShortcutSet(shortcut, button.getContextComponent());
            }
            if (!(button instanceof RemoveButton)) continue;
            CommonActionsPanel.registerDeleteHook((MyActionButton)button);
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        JRootPane pane = this.getRootPane();
        for (AnActionButton button : this.myActions) {
            if (!(button instanceof AddButton) || !UIUtil.isDialogRootPane((JRootPane)pane)) continue;
            button.unregisterCustomShortcutSet(pane);
        }
        super.removeNotify();
    }

    private static void registerDeleteHook(final MyActionButton removeButton) {
        new AnAction(IdeBundle.messagePointer("action.Anonymous.text.delete.hook", new Object[0])){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                removeButton.actionPerformed(e);
            }

            @Override
            public boolean isDumbAware() {
                return removeButton.isDumbAware();
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                JComponent contextComponent = removeButton.getContextComponent();
                if (contextComponent instanceof JTable && ((JTable)contextComponent).isEditing()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply(contextComponent);
                if (supply != null && supply.isPopupActive()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                removeButton.update(e);
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("DELETE", "BACK_SPACE"), removeButton.getContextComponent());
    }

    public void setEnabled(Buttons button, boolean enabled) {
        AnActionButton b = this.myButtons.get((Object)button);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public void setCustomShortcuts(@NotNull Buttons button, ShortcutSet ... shortcutSets) {
        if (shortcutSets != null) {
            if (this.myCustomShortcuts == null) {
                this.myCustomShortcuts = new EnumMap(Buttons.class);
            }
            this.myCustomShortcuts.put(button, new CompositeShortcutSet(shortcutSets));
        } else if (this.myCustomShortcuts != null) {
            this.myCustomShortcuts.remove((Object)button);
            if (this.myCustomShortcuts.isEmpty()) {
                this.myCustomShortcuts = null;
            }
        }
    }

    @NotNull
    public ActionToolbarPosition getPosition() {
        return this.myPosition;
    }

    @NotNull
    public static ShortcutSet getCommonShortcut(@NotNull Buttons button) {
        switch (button) {
            case ADD: {
                return CommonShortcuts.getNewForDialogs();
            }
            case EDIT: {
                return CustomShortcutSet.fromString("ENTER");
            }
            case REMOVE: {
                return CustomShortcutSet.fromString(SystemInfo.isMac ? "meta BACK_SPACE" : "alt DELETE");
            }
            case UP: {
                return CommonShortcuts.MOVE_UP;
            }
            case DOWN: {
                return CommonShortcuts.MOVE_DOWN;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)button));
    }

    static interface ListenerFactory {
        @NotNull
        public Listener createListener(@NotNull CommonActionsPanel var1);
    }

    static class DownButton
    extends MyActionButton {
        DownButton(Listener listener2, String name, Icon icon) {
            super(Buttons.DOWN, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && max < size - 1;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myListener.doDown();
        }
    }

    static class UpButton
    extends MyActionButton {
        UpButton(Listener listener2, String name, Icon icon) {
            super(Buttons.UP, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min >= 1;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myListener.doUp();
        }
    }

    static class EditButton
    extends MyActionButton {
        EditButton(Listener listener2, String name, Icon icon) {
            super(Buttons.EDIT, listener2, name, icon);
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            JComponent c = this.getContextComponent();
            if (c == null || !c.isShowing() || !c.isEnabled()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof KeyEvent && c instanceof JTable && ((JTable)c).isEditing() && !(inputEvent.getComponent() instanceof ActionButtonComponent)) {
                e.getPresentation().setEnabled(false);
                return;
            }
            super.updateButton(e);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0 && min == max && min >= 0;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myListener.doEdit();
        }
    }

    static class RemoveButton
    extends MyActionButton {
        RemoveButton(Listener listener2, String name, Icon icon) {
            super(Buttons.REMOVE, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return size > 0;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myListener.doRemove();
        }
    }

    static class AddButton
    extends MyActionButton {
        AddButton(Listener listener2, String name, Icon icon) {
            super(Buttons.ADD, listener2, name, icon);
        }

        @Override
        protected boolean isEnabled(int size, int min, int max) {
            return true;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myListener.doAdd();
        }
    }

    static abstract class MyActionButton
    extends AnActionButton
    implements DumbAware {
        private final Buttons myButton;
        protected final Listener myListener;

        MyActionButton(@NotNull Buttons button, @NotNull Listener listener2, @NotNull String name, @NotNull Icon icon) {
            super(name, name, icon);
            this.myButton = button;
            this.myListener = listener2;
        }

        @Override
        public ShortcutSet getShortcut() {
            return CommonActionsPanel.getCommonShortcut(this.myButton);
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            super.updateButton(e);
            if (!e.getPresentation().isEnabled()) {
                return;
            }
            JComponent c = this.getContextComponent();
            if (c instanceof JTable || c instanceof JList) {
                ListSelectionModel model = c instanceof JTable ? ((JTable)c).getSelectionModel() : ((JList)c).getSelectionModel();
                int size = c instanceof JTable ? ((JTable)c).getRowCount() : ((JList)c).getModel().getSize();
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                e.getPresentation().setEnabled(this.isEnabled() && this.isEnabled(size, min, max));
            }
        }

        protected abstract boolean isEnabled(int var1, int var2, int var3);
    }

    public static interface Listener {
        default public void doAdd() {
        }

        default public void doRemove() {
        }

        default public void doUp() {
        }

        default public void doDown() {
        }

        default public void doEdit() {
        }
    }

    public static enum Buttons {
        ADD(IconUtil.getAddIcon(), (Supplier)UIBundle.messagePointer("button.text.add", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                return new AddButton(listener2, name == null ? this.getText() : name, icon);
            }
        }
        ,
        REMOVE(IconUtil.getRemoveIcon(), (Supplier)UIBundle.messagePointer("button.text.remove", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                return new RemoveButton(listener2, name == null ? this.getText() : name, icon);
            }
        }
        ,
        EDIT(IconUtil.getEditIcon(), (Supplier)UIBundle.messagePointer("button.text.edit", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                return new EditButton(listener2, name == null ? this.getText() : name, icon);
            }
        }
        ,
        UP(IconUtil.getMoveUpIcon(), (Supplier)UIBundle.messagePointer("button.text.up", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                return new UpButton(listener2, name == null ? this.getText() : name, icon);
            }
        }
        ,
        DOWN(IconUtil.getMoveDownIcon(), (Supplier)UIBundle.messagePointer("button.text.down", new Object[0])){

            @Override
            @NotNull
            AnActionButton createButton(@NotNull Listener listener2, String name, @NotNull Icon icon) {
                return new DownButton(listener2, name == null ? this.getText() : name, icon);
            }
        };

        private final Icon myIcon;
        @NotNull
        private final Supplier<String> myText;

        private Buttons(Icon icon, Supplier<String> text) {
            this.myIcon = icon;
            this.myText = text;
        }

        @NotNull
        public Icon getIcon() {
            return this.myIcon;
        }

        @NotNull
        abstract AnActionButton createButton(@NotNull Listener var1, String var2, @NotNull Icon var3);

        @NotNull
        public String getText() {
            return this.myText.get();
        }
    }
}

