/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIdentityHashingStrategy;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimatedIcon
implements Icon {
    private static final Logger LOG = Logger.getInstance(AnimatedIcon.class);
    @ApiStatus.Internal
    public static final Key<Boolean> ANIMATION_IN_RENDERER_ALLOWED = Key.create((String)"ANIMATION_IN_RENDERER_ALLOWED");
    @ApiStatus.Internal
    public static final Key<Runnable> REFRESH_DELEGATE = Key.create((String)"REFRESH_DELEGATE");
    private final Frame[] frames;
    private final Set<Component> requested = new SmartHashSet((TObjectHashingStrategy)new TObjectIdentityHashingStrategy());
    private long time;
    private int index;

    public AnimatedIcon(int delay, Icon ... icons) {
        this(AnimatedIcon.getFrames(delay, icons));
    }

    public AnimatedIcon(Frame ... frames) {
        this.frames = frames;
        assert (frames.length > 0) : "empty array";
        for (Frame frame : frames) {
            assert (frame != null) : "null animation frame";
        }
        this.time = System.currentTimeMillis();
    }

    private static Frame[] getFrames(final int delay, Icon ... icons) {
        int length = icons.length;
        assert (length > 0) : "empty array";
        Frame[] frames = new Frame[length];
        for (int i = 0; i < length; ++i) {
            final Icon icon = icons[i];
            assert (icon != null) : "null icon";
            frames[i] = new Frame(){

                @Override
                @NotNull
                public Icon getIcon() {
                    return icon;
                }

                @Override
                public int getDelay() {
                    return delay;
                }
            };
        }
        return frames;
    }

    private void updateFrameAt(long current) {
        int next = this.index + 1;
        this.index = next < this.frames.length ? next : 0;
        this.time = current;
    }

    @NotNull
    private Icon getUpdatedIcon() {
        int index = this.getCurrentIndex();
        return this.frames[index].getIcon();
    }

    private int getCurrentIndex() {
        long current = System.currentTimeMillis();
        Frame frame = this.frames[this.index];
        if ((long)frame.getDelay() <= current - this.time) {
            this.updateFrameAt(current);
        }
        return this.index;
    }

    private void requestRefresh(@Nullable Component c) {
        if (c != null && !this.requested.contains(c) && this.canRefresh(c)) {
            Frame frame = this.frames[this.index];
            int delay = frame.getDelay();
            if (delay > 0) {
                this.requested.add(c);
                EdtScheduledExecutorService.getInstance().schedule(() -> {
                    this.requested.remove(c);
                    if (this.canRefresh(c)) {
                        this.doRefresh(c);
                    }
                }, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                this.doRefresh(c);
            }
        }
    }

    @Override
    public final void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.getUpdatedIcon();
        if (EventQueue.isDispatchThread()) {
            CellRendererPane pane = (CellRendererPane)ComponentUtil.getParentOfType(CellRendererPane.class, (Component)c);
            this.requestRefresh(pane == null ? c : this.getRendererOwner(pane.getParent()));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Throwable)new IllegalStateException("Unexpected thread " + Thread.currentThread().getName()));
        }
        icon.paintIcon(c, g, x, y);
    }

    @Override
    public final int getIconWidth() {
        return this.getUpdatedIcon().getIconWidth();
    }

    @Override
    public final int getIconHeight() {
        return this.getUpdatedIcon().getIconHeight();
    }

    protected boolean canRefresh(@NotNull Component component) {
        return component.isShowing();
    }

    protected void doRefresh(@NotNull Component component) {
        Runnable delegate = (Runnable)UIUtil.getClientProperty((Object)component, REFRESH_DELEGATE);
        if (delegate != null) {
            delegate.run();
        } else {
            component.repaint();
        }
    }

    @Nullable
    protected Component getRendererOwner(@Nullable Component component) {
        return UIUtil.isClientPropertyTrue((Object)component, ANIMATION_IN_RENDERER_ALLOWED) ? component : null;
    }

    @ApiStatus.Internal
    public static class Fading
    extends AnimatedIcon {
        public Fading(@NotNull Icon icon) {
            this(1000, icon);
        }

        public Fading(final int period, final @NotNull Icon icon) {
            super(50, new Icon(){
                private final long time = System.currentTimeMillis();

                @Override
                public int getIconWidth() {
                    return icon.getIconWidth();
                }

                @Override
                public int getIconHeight() {
                    return icon.getIconHeight();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    assert (period > 0) : "unexpected";
                    long time = (System.currentTimeMillis() - this.time) % (long)period;
                    float alpha = (float)((Math.cos(Math.PI * 2 * (double)time / (double)period) + 1.0) / 2.0);
                    if (alpha > 0.0f) {
                        if (alpha < 1.0f && g instanceof Graphics2D) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            try {
                                g2d.setComposite(AlphaComposite.SrcAtop.derive(alpha));
                                icon.paintIcon(c, g2d, x, y);
                            }
                            finally {
                                g2d.dispose();
                            }
                        } else {
                            icon.paintIcon(c, g, x, y);
                        }
                    }
                }
            });
        }
    }

    @ApiStatus.Internal
    public static class Blinking
    extends AnimatedIcon {
        public Blinking(@NotNull Icon icon) {
            this(1000, icon);
        }

        public Blinking(int delay, @NotNull Icon icon) {
            super(delay, icon, IconLoader.getDisabledIcon((Icon)icon));
        }
    }

    @ApiStatus.Internal
    public static class FS
    extends AnimatedIcon {
        public static final int DELAY = 50;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Process.FS.Step_1, AllIcons.Process.FS.Step_2, AllIcons.Process.FS.Step_3, AllIcons.Process.FS.Step_4, AllIcons.Process.FS.Step_5, AllIcons.Process.FS.Step_6, AllIcons.Process.FS.Step_7, AllIcons.Process.FS.Step_8, AllIcons.Process.FS.Step_9, AllIcons.Process.FS.Step_10, AllIcons.Process.FS.Step_11, AllIcons.Process.FS.Step_12, AllIcons.Process.FS.Step_13, AllIcons.Process.FS.Step_14, AllIcons.Process.FS.Step_15, AllIcons.Process.FS.Step_16, AllIcons.Process.FS.Step_17, AllIcons.Process.FS.Step_18});

        public FS() {
            super(50, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Recording
    extends AnimatedIcon {
        public static final int DELAY = 250;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Ide.Macro.Recording_1, AllIcons.Ide.Macro.Recording_2, AllIcons.Ide.Macro.Recording_3, AllIcons.Ide.Macro.Recording_4});

        public Recording() {
            super(250, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Big
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Process.Big.Step_1, AllIcons.Process.Big.Step_2, AllIcons.Process.Big.Step_3, AllIcons.Process.Big.Step_4, AllIcons.Process.Big.Step_5, AllIcons.Process.Big.Step_6, AllIcons.Process.Big.Step_7, AllIcons.Process.Big.Step_8});

        public Big() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static class Default
    extends AnimatedIcon {
        public static final int DELAY = 130;
        public static final List<Icon> ICONS = ContainerUtil.immutableList((Object[])new Icon[]{AllIcons.Process.Step_1, AllIcons.Process.Step_2, AllIcons.Process.Step_3, AllIcons.Process.Step_4, AllIcons.Process.Step_5, AllIcons.Process.Step_6, AllIcons.Process.Step_7, AllIcons.Process.Step_8});
        public static final AnimatedIcon INSTANCE = new Default();

        public Default() {
            super(130, ICONS.toArray(new Icon[0]));
        }
    }

    public static interface Frame {
        @NotNull
        public Icon getIcon();

        public int getDelay();
    }
}

