/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<? super H, ? extends T> myFunction;

    private PsiCacheKey(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function) {
        super(name);
        this.myFunction = function;
    }

    public final T getValue(@NotNull H h) {
        Object result = this.getCachedValueOrNull(h);
        if (result != null) {
            return result;
        }
        result = this.myFunction.fun(h);
        long count = PsiCacheKey.getModificationCount(h);
        h.putUserData((Key)this, (Object)new SoftReference((Object)new Pair((Object)count, result)));
        return result;
    }

    @Nullable
    public final T getCachedValueOrNull(@NotNull H h) {
        SoftReference ref = (SoftReference)h.getUserData((Key)this);
        Pair data = (Pair)SoftReference.dereference((Reference)ref);
        if (data == null || (Long)data.getFirst() != PsiCacheKey.getModificationCount(h)) {
            return null;
        }
        return (T)data.getSecond();
    }

    private static long getModificationCount(@NotNull PsiElement element) {
        ModelBranch branch;
        PsiFile file = element.getContainingFile();
        long nonPhysicalStamp = file == null || file.isPhysical() ? 0L : file.getModificationStamp();
        ModelBranch modelBranch = branch = file == null ? null : ModelBranch.getPsiBranch(file);
        if (branch != null) {
            nonPhysicalStamp += branch.getBranchedPsiModificationCount();
        }
        PsiElement root = file != null ? file : element;
        return nonPhysicalStamp + root.getManager().getModificationTracker().getModificationCount();
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function) {
        return new PsiCacheKey<T, H>(name, function);
    }
}

