/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProximityLocation
implements UserDataHolder {
    private final PsiElement myPosition;
    private final Module myPositionModule;
    private final ProcessingContext myContext;

    public ProximityLocation(@Nullable PsiElement position, Module positionModule) {
        this(position, positionModule, new ProcessingContext());
    }

    public ProximityLocation(PsiElement position, @Nullable Module positionModule, ProcessingContext context) {
        this.myPosition = position;
        this.myPositionModule = positionModule;
        this.myContext = context;
    }

    @Nullable
    public Module getPositionModule() {
        return this.myPositionModule;
    }

    @Nullable
    public PsiElement getPosition() {
        return this.myPosition;
    }

    @Nullable
    public Project getProject() {
        return this.myPosition != null ? this.myPosition.getProject() : null;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myContext.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myContext.put(key, value);
    }
}

