/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ILazyParseableElementType
extends IElementType
implements ILazyParseableElementTypeBase {
    public static final Key<Language> LANGUAGE_KEY = Key.create((String)"LANGUAGE_KEY");

    public ILazyParseableElementType(@NotNull @NonNls String debugName) {
        this(debugName, null);
    }

    public ILazyParseableElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        super(debugName, language);
    }

    public ILazyParseableElementType(@NotNull @NonNls String debugName, @Nullable Language language, boolean register2) {
        super(debugName, language, register2);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public PsiBuilder parseLight(ASTNode chameleon) {
        throw new UnsupportedOperationException(String.valueOf(chameleon));
    }

    @Override
    public ASTNode parseContents(@NotNull ASTNode chameleon) {
        PsiElement parentElement = chameleon.getTreeParent().getPsi();
        assert (parentElement != null) : "parent psi is null: " + chameleon;
        return this.doParseContents(chameleon, parentElement);
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        Project project = psi.getProject();
        Language languageForParser = this.getLanguageForParser(psi);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, languageForParser, chameleon.getChars());
        PsiParser parser = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(languageForParser)).createParser(project);
        ASTNode node = parser.parse(this, builder);
        return node.getFirstChildNode();
    }

    protected Language getLanguageForParser(PsiElement psi) {
        return this.getLanguage();
    }

    @Nullable
    public ASTNode createNode(CharSequence text) {
        return null;
    }

    @Override
    public boolean reuseCollapsedTokens() {
        return false;
    }
}

