/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatisticsInfo {
    public static final StatisticsInfo EMPTY = new StatisticsInfo("empty", "empty");
    private final String myContext;
    private final String myValue;
    private final List<StatisticsInfo> myConjuncts;

    public StatisticsInfo(@NonNls @NotNull String context, @NonNls @NotNull String value) {
        this.myContext = context;
        this.myValue = value;
        this.myConjuncts = Collections.singletonList(this);
    }

    private StatisticsInfo(String context, String value, List<StatisticsInfo> conjuncts) {
        this.myContext = context;
        this.myValue = value;
        this.myConjuncts = conjuncts;
    }

    public static StatisticsInfo createComposite(List<? extends StatisticsInfo> conjuncts) {
        if (conjuncts.isEmpty()) {
            return EMPTY;
        }
        ArrayList<StatisticsInfo> flattened = new ArrayList<StatisticsInfo>(conjuncts.size());
        for (StatisticsInfo statisticsInfo : conjuncts) {
            flattened.addAll(statisticsInfo.getConjuncts());
        }
        return new StatisticsInfo(conjuncts.get(0).getContext(), conjuncts.get(0).getValue(), flattened);
    }

    @NotNull
    public String getContext() {
        return this.myContext;
    }

    @NotNull
    public String getValue() {
        return this.myValue;
    }

    public List<StatisticsInfo> getConjuncts() {
        return this.myConjuncts;
    }

    public String toString() {
        return this.myContext + "::::" + this.myValue + (this.myConjuncts.size() == 1 ? "" : "::::" + this.myConjuncts);
    }
}

