/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public abstract class CompoundPackageSet
extends PackageSetBase {
    final PackageSet[] mySets;
    String myText;

    CompoundPackageSet(PackageSet ... sets) {
        this.mySets = sets;
        for (PackageSet set : sets) {
            if (set != null) continue;
            throw new IllegalArgumentException("null set in " + Arrays.toString(sets));
        }
    }

    @Override
    public boolean contains(@NotNull VirtualFile file, @NotNull NamedScopesHolder holder) {
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        return this.map(s -> s.createCopy());
    }

    @Override
    public boolean anyMatches(@NotNull Predicate<? super PackageSet> predicate) {
        return ContainerUtil.or((Object[])this.mySets, s -> predicate.test((PackageSet)s));
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myText == null) {
            this.myText = StringUtil.join((Object[])this.mySets, s -> s.getText(), (String)"||");
        }
        return this.myText;
    }

    public PackageSet @NotNull [] getSets() {
        return this.mySets;
    }
}

