/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import org.jetbrains.annotations.NotNull;

public class CodeStyleBoundedIntegerSettingPresentation
extends CodeStyleSettingPresentation {
    protected int myLowerBound;
    protected int myUpperBound;
    protected int myDefaultValue;
    protected String myDefaultValueUiName;

    public CodeStyleBoundedIntegerSettingPresentation(@NotNull String fieldName, @NotNull String uiName, int lowerBound, int upperBound, int defaultValue, String defaultValueUiName) {
        super(fieldName, uiName);
        this.myLowerBound = lowerBound;
        this.myUpperBound = upperBound;
        this.myDefaultValue = defaultValue;
        this.myDefaultValueUiName = defaultValueUiName;
    }

    public int getLowerBound() {
        return this.myLowerBound;
    }

    public int getUpperBound() {
        return this.myUpperBound;
    }

    public int getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    @NotNull
    public String getValueUiName(@NotNull Object value) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            return intValue == this.myDefaultValue ? this.myDefaultValueUiName : super.getValueUiName(value);
        }
        return super.getValueUiName(value);
    }
}

