/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettingsManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectCodeStyleConfiguration", storages={@Storage(value="codeStyles", stateSplitter=StateSplitter.class)})
public class ProjectCodeStyleSettingsManager
extends CodeStyleSettingsManager {
    private static final Logger LOG = Logger.getInstance(ProjectCodeStyleSettingsManager.class);
    private static final String MAIN_PROJECT_CODE_STYLE_NAME = "Project";
    private static final String PROJECT_CODE_STYLE_CONFIG_FILE_NAME = "codeStyleConfig";
    private final Project myProject;
    private boolean myIsLoaded;
    private final Map<String, CodeStyleSettings> mySettingsMap = new HashMap<String, CodeStyleSettings>();
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Code style settings migration", NotificationDisplayType.STICKY_BALLOON, true, null, null, null, PluginId.getId((String)"com.intellij"));

    public ProjectCodeStyleSettingsManager(Project project) {
        this.myProject = project;
        this.setMainProjectCodeStyle(null);
        this.registerExtensionPointListeners((Disposable)project);
    }

    @Override
    public void initializeComponent() {
        this.initProjectSettings(this.myProject);
        this.getCurrentSettings();
    }

    private void initProjectSettings(@NotNull Project project) {
        if (!this.myIsLoaded) {
            LegacyCodeStyleSettingsManager legacySettingsManager = ServiceManager.getService(project, LegacyCodeStyleSettingsManager.class);
            if (legacySettingsManager != null && legacySettingsManager.getState() != null) {
                this.loadState(legacySettingsManager.getState());
                if (!(project.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                    ProjectCodeStyleSettingsManager.saveProjectAndNotify(project);
                }
                LOG.info("Imported old project code style settings.");
            } else {
                this.initDefaults();
                LOG.info("Initialized from default code style settings.");
            }
        }
    }

    private static void saveProjectAndNotify(@NotNull Project project) {
        ApplicationManager.getApplication().invokeLater(() -> {
            project.save();
            CodeStyleMigrationNotification notification = new CodeStyleMigrationNotification(project.getName());
            notification.notify(project);
        }, project.getDisposed());
    }

    @Override
    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        this.mySettingsMap.put(MAIN_PROJECT_CODE_STYLE_NAME, settings != null ? settings : this.createSettings());
    }

    @Override
    @NotNull
    public CodeStyleSettings getMainProjectCodeStyle() {
        return this.mySettingsMap.get(MAIN_PROJECT_CODE_STYLE_NAME);
    }

    private void initDefaults() {
        CodeStyleSettingsManager appCodeStyleSettingsManager = CodeStyleSettingsManager.getInstance();
        if (appCodeStyleSettingsManager != null) {
            CodeStyleSettings defaultProjectSettings = appCodeStyleSettingsManager.getMainProjectCodeStyle();
            this.setMainProjectCodeStyle(defaultProjectSettings != null ? this.cloneSettings(defaultProjectSettings) : null);
            this.USE_PER_PROJECT_SETTINGS = appCodeStyleSettingsManager.USE_PER_PROJECT_SETTINGS;
            this.PREFERRED_PROJECT_CODE_STYLE = appCodeStyleSettingsManager.PREFERRED_PROJECT_CODE_STYLE;
        }
    }

    @Override
    public void loadState(@NotNull Element state) {
        LOG.info("Loading Project code style");
        super.loadState(state);
        this.updateFromOldProjectSettings();
        for (Element subStyle : state.getChildren("code_scheme")) {
            String name = subStyle.getAttributeValue("name");
            CodeStyleSettings settings = this.createSettings();
            settings.readExternal(subStyle);
            if (MAIN_PROJECT_CODE_STYLE_NAME.equals(name)) {
                this.setMainProjectCodeStyle(settings);
            } else {
                this.mySettingsMap.put(name, settings);
            }
            LOG.info(name + " code style loaded");
        }
        this.myIsLoaded = true;
    }

    private void updateFromOldProjectSettings() {
        CodeStyleSettings oldProjectSettings = this.PER_PROJECT_SETTINGS;
        if (oldProjectSettings != null) {
            oldProjectSettings.resetDeprecatedFields();
        }
        this.setMainProjectCodeStyle(oldProjectSettings);
        this.PER_PROJECT_SETTINGS = null;
    }

    @Override
    public Element getState() {
        Element e = super.getState();
        if (e != null) {
            LOG.info("Saving Project code style");
            for (String name : this.mySettingsMap.keySet()) {
                CodeStyleSettings settings = this.mySettingsMap.get(name);
                Element codeStyle = new Element("code_scheme");
                codeStyle.setAttribute("name", name);
                settings.writeExternal(codeStyle);
                if (codeStyle.getContent().isEmpty()) continue;
                e.addContent(codeStyle);
                LOG.info(name + " code style saved");
            }
        }
        return e;
    }

    @Override
    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        return "PER_PROJECT_SETTINGS".equals(fieldName);
    }

    @Override
    protected Collection<CodeStyleSettings> enumSettings() {
        return Collections.unmodifiableCollection(this.mySettingsMap.values());
    }

    static final class StateSplitter
    extends MainConfigurationStateSplitter {
        StateSplitter() {
        }

        @Override
        @NotNull
        protected String getComponentStateFileName() {
            return ProjectCodeStyleSettingsManager.PROJECT_CODE_STYLE_CONFIG_FILE_NAME;
        }

        @Override
        @NotNull
        protected String getSubStateTagName() {
            return "code_scheme";
        }

        @Override
        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            return element.getAttributeValue("name");
        }
    }

    private static class ShowMoreInfoAction
    extends DumbAwareAction {
        ShowMoreInfoAction() {
            super(IdeBundle.messagePointer("action.ProjectCodeStyleSettingsManager.ShowMoreInfoAction.text.more.info", new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            BrowserUtil.open("https://confluence.jetbrains.com/display/IDEADEV/New+project+code+style+settings+format+in+2017.3");
        }
    }

    private static class CodeStyleMigrationNotification
    extends Notification {
        CodeStyleMigrationNotification(@NotNull String projectName) {
            super(NOTIFICATION_GROUP.getDisplayId(), ApplicationBundle.message("project.code.style.migration.title", new Object[0]), ApplicationBundle.message("project.code.style.migration.message", projectName), NotificationType.INFORMATION);
            this.addAction(new ShowMoreInfoAction());
        }
    }
}

