/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThreadLocalCachedValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntaxTraverser<T>
extends FilteredTraverserBase<T, SyntaxTraverser<T>>
implements UserDataHolder {
    public final Api<T> api;

    @NotNull
    public static ApiEx<PsiElement> psiApi() {
        return PsiApi.INSTANCE;
    }

    @NotNull
    public static ApiEx<PsiElement> psiApiReversed() {
        return PsiApi.INSTANCE_REV;
    }

    @NotNull
    public static ApiEx<ASTNode> astApi() {
        return ASTApi.INSTANCE;
    }

    @NotNull
    public static Api<LighterASTNode> lightApi(@NotNull PsiBuilder builder) {
        return new LighterASTApi(builder);
    }

    @NotNull
    public static <T> SyntaxTraverser<T> syntaxTraverser(@NotNull Api<T> api) {
        return new SyntaxTraverser<T>(api, null);
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> psiTraverser() {
        return new SyntaxTraverser<PsiElement>(SyntaxTraverser.psiApi(), null);
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> psiTraverser(@Nullable PsiElement root) {
        return (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(root);
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> revPsiTraverser() {
        return new SyntaxTraverser<PsiElement>(SyntaxTraverser.psiApiReversed(), null);
    }

    @NotNull
    public static SyntaxTraverser<ASTNode> astTraverser() {
        return new SyntaxTraverser<ASTNode>(SyntaxTraverser.astApi(), null);
    }

    @NotNull
    public static SyntaxTraverser<ASTNode> astTraverser(@Nullable ASTNode root) {
        return (SyntaxTraverser)SyntaxTraverser.astTraverser().withRoot(root);
    }

    @NotNull
    public static SyntaxTraverser<LighterASTNode> lightTraverser(@NotNull PsiBuilder builder) {
        LighterASTApi api = new LighterASTApi(builder);
        FilteredTraverserBase.Meta meta = FilteredTraverserBase.Meta.create((Function)api).forceExpand(Conditions.compose(api::typeOf, (Condition)Conditions.instanceOf(IFileElementType.class))).withRoots((Iterable)JBIterable.of((Object)api.getStructure().getRoot()));
        return new SyntaxTraverser<LighterASTNode>(api, meta);
    }

    protected SyntaxTraverser(@NotNull Api<T> api, @Nullable FilteredTraverserBase.Meta<T> meta) {
        super(meta == null ? FilteredTraverserBase.Meta.create(api).forceExpand(Conditions.compose(api::typeOf, (Condition)Conditions.instanceOf(IFileElementType.class))) : meta);
        this.api = api;
    }

    @NotNull
    protected SyntaxTraverser<T> newInstance(@NotNull FilteredTraverserBase.Meta<T> meta) {
        return new SyntaxTraverser<T>(this.api, meta);
    }

    @NotNull
    public final <S> SyntaxTraverser<S> map(@NotNull Function<? super T, ? extends S> function, @NotNull Function<? super S, ? extends T> reverse) {
        return (SyntaxTraverser)super.mapImpl(function, reverse);
    }

    @NotNull
    public final <S> SyntaxTraverser<S> map(@NotNull Function<? super T, ? extends S> function) {
        return (SyntaxTraverser)super.mapImpl(function);
    }

    @Nullable
    public <K> K getUserData(@NotNull Key<K> key) {
        return (K)this.getUserDataHolder().getUserData(key);
    }

    public <K> void putUserData(@NotNull Key<K> key, @Nullable K value) {
        this.getUserDataHolder().putUserData(key, value);
    }

    private UserDataHolder getUserDataHolder() {
        return this.api instanceof LighterASTApi ? ((LighterASTApi)this.api).userDataHolder : (UserDataHolder)this.api.parents(this.getRoot()).last();
    }

    @NotNull
    public SyntaxTraverser<T> expandTypes(@NotNull Condition<? super IElementType> c) {
        return (SyntaxTraverser)super.expand(Conditions.compose(this.api.TO_TYPE, c));
    }

    @NotNull
    public SyntaxTraverser<T> filterTypes(@NotNull Condition<? super IElementType> c) {
        return (SyntaxTraverser)super.filter(Conditions.compose(this.api.TO_TYPE, c));
    }

    @NotNull
    public SyntaxTraverser<T> forceDisregardTypes(@NotNull Condition<? super IElementType> c) {
        return (SyntaxTraverser)super.forceDisregard(Conditions.compose(this.api.TO_TYPE, c));
    }

    @Nullable
    public T getRawDeepestLast() {
        Object result = JBIterable.from((Iterable)this.getRoots()).last();
        while (result != null) {
            Object last;
            JBIterable children = this.children(result);
            if (children.isEmpty()) {
                return (T)result;
            }
            result = last = children.last();
        }
        return null;
    }

    @NotNull
    public final SyntaxTraverser<T> onRange(@NotNull TextRange range) {
        return (SyntaxTraverser)this.onRange(e -> this.api.rangeOf(e).intersects(range));
    }

    private static class LighterASTApi
    extends FlyweightApi<LighterASTNode> {
        private final PsiBuilder builder;
        private final UserDataHolder userDataHolder = new UserDataHolderBase();
        private final ThreadLocalCachedValue<FlyweightCapableTreeStructure<LighterASTNode>> structure = new ThreadLocalCachedValue<FlyweightCapableTreeStructure<LighterASTNode>>(){

            @NotNull
            protected FlyweightCapableTreeStructure<LighterASTNode> create() {
                return builder.getLightTree();
            }
        };

        LighterASTApi(PsiBuilder builder) {
            this.builder = builder;
        }

        @Override
        @NotNull
        FlyweightCapableTreeStructure<LighterASTNode> getStructure() {
            return (FlyweightCapableTreeStructure)this.structure.getValue();
        }

        @Override
        @NotNull
        public IElementType typeOf(@NotNull LighterASTNode node) {
            return node.getTokenType();
        }

        @Override
        @NotNull
        public TextRange rangeOf(@NotNull LighterASTNode node) {
            return TextRange.create((int)node.getStartOffset(), (int)node.getEndOffset());
        }

        @Override
        @NotNull
        public CharSequence textOf(@NotNull LighterASTNode node) {
            return this.rangeOf(node).subSequence(this.builder.getOriginalText());
        }

        @Override
        @Nullable
        public LighterASTNode parent(@NotNull LighterASTNode node) {
            return node instanceof LighterASTTokenNode ? null : super.parent(node);
        }
    }

    private static abstract class FlyweightApi<T>
    extends Api<T> {
        private FlyweightApi() {
        }

        @NotNull
        abstract FlyweightCapableTreeStructure<T> getStructure();

        @Override
        @Nullable
        public T parent(@NotNull T node) {
            return (T)this.getStructure().getParent(node);
        }

        @Override
        @NotNull
        public JBIterable<? extends T> children(final @NotNull T node) {
            return new JBIterable<T>(){

                public Iterator<T> iterator() {
                    Ref ref;
                    FlyweightCapableTreeStructure structure = this.getStructure();
                    int count = structure.getChildren(node, ref = Ref.create());
                    if (count == 0) {
                        return Collections.emptyIterator();
                    }
                    Object[] array = (Object[])ref.get();
                    LinkedList<Object> list = new LinkedList<Object>();
                    for (int i = 0; i < count; ++i) {
                        Object child = array[i];
                        IElementType childType = this.typeOf(child);
                        if (childType == TokenType.WHITE_SPACE || childType == TokenType.BAD_CHARACTER) continue;
                        array[i] = null;
                        list.addLast(child);
                    }
                    structure.disposeChildren(array, count);
                    return list.iterator();
                }
            };
        }
    }

    private static class ASTApi
    extends ApiEx<ASTNode> {
        static final ASTApi INSTANCE = new ASTApi();

        private ASTApi() {
        }

        @Override
        @Nullable
        public ASTNode first(@NotNull ASTNode node) {
            return node.getFirstChildNode();
        }

        @Override
        @Nullable
        public ASTNode last(@NotNull ASTNode node) {
            return node.getLastChildNode();
        }

        @Override
        @Nullable
        public ASTNode next(@NotNull ASTNode node) {
            return node.getTreeNext();
        }

        @Override
        @Nullable
        public ASTNode previous(@NotNull ASTNode node) {
            return node.getTreePrev();
        }

        @Override
        @NotNull
        public IElementType typeOf(@NotNull ASTNode node) {
            return node.getElementType();
        }

        @Override
        @NotNull
        public TextRange rangeOf(@NotNull ASTNode node) {
            return node.getTextRange();
        }

        @Override
        @NotNull
        public CharSequence textOf(@NotNull ASTNode node) {
            return node.getText();
        }

        @Override
        @Nullable
        public ASTNode parent(@NotNull ASTNode node) {
            return node.getTreeParent();
        }
    }

    private static class PsiApi
    extends ApiEx<PsiElement> {
        static final ApiEx<PsiElement> INSTANCE = new PsiApi();
        static final ApiEx<PsiElement> INSTANCE_REV = new PsiApi(){

            @Override
            @Nullable
            public PsiElement previous(@NotNull PsiElement node) {
                return super.next(node);
            }

            @Override
            @Nullable
            public PsiElement next(@NotNull PsiElement node) {
                return super.previous(node);
            }

            @Override
            @Nullable
            public PsiElement last(@NotNull PsiElement node) {
                return super.first(node);
            }

            @Override
            @Nullable
            public PsiElement first(@NotNull PsiElement node) {
                return super.last(node);
            }
        };

        private PsiApi() {
        }

        @Override
        @Nullable
        public PsiElement first(@NotNull PsiElement node) {
            return node.getFirstChild();
        }

        @Override
        @Nullable
        public PsiElement last(@NotNull PsiElement node) {
            return node.getLastChild();
        }

        @Override
        @Nullable
        public PsiElement next(@NotNull PsiElement node) {
            return node.getNextSibling();
        }

        @Override
        @Nullable
        public PsiElement previous(@NotNull PsiElement node) {
            return node.getPrevSibling();
        }

        @Override
        @NotNull
        public IElementType typeOf(@NotNull PsiElement node) {
            IElementType type = PsiUtilCore.getElementType(node);
            return type != null ? type : IElementType.find((short)0);
        }

        @Override
        @NotNull
        public TextRange rangeOf(@NotNull PsiElement node) {
            return node.getTextRange();
        }

        @Override
        @NotNull
        public CharSequence textOf(@NotNull PsiElement node) {
            return node.getText();
        }

        @Override
        @Nullable
        public PsiElement parent(@NotNull PsiElement node) {
            return node instanceof PsiFile ? null : node.getParent();
        }
    }

    public static abstract class ApiEx<T>
    extends Api<T> {
        private final Function<T, T> TO_NEXT = new Function<T, T>(){

            public T fun(T t) {
                return this.next(t);
            }

            public String toString() {
                return "TO_NEXT";
            }
        };

        @Nullable
        public abstract T first(@NotNull T var1);

        @Nullable
        public abstract T last(@NotNull T var1);

        @Nullable
        public abstract T next(@NotNull T var1);

        @Nullable
        public abstract T previous(@NotNull T var1);

        @Override
        @NotNull
        public JBIterable<? extends T> children(@NotNull T node) {
            T first = this.first(node);
            if (first == null) {
                return JBIterable.empty();
            }
            return this.siblings(first);
        }

        @NotNull
        public JBIterable<? extends T> siblings(@NotNull T node) {
            return JBIterable.generate(node, this.TO_NEXT);
        }
    }

    public static abstract class Api<T>
    implements Function<T, Iterable<? extends T>> {
        public final Function<T, IElementType> TO_TYPE = new Function<T, IElementType>(){

            public IElementType fun(T t) {
                return this.typeOf(t);
            }

            public String toString() {
                return "TO_TYPE";
            }
        };
        public final Function<T, CharSequence> TO_TEXT = new Function<T, CharSequence>(){

            public CharSequence fun(T t) {
                return this.textOf(t);
            }

            public String toString() {
                return "TO_TEXT";
            }
        };
        public final Function<T, TextRange> TO_RANGE = new Function<T, TextRange>(){

            public TextRange fun(T t) {
                return this.rangeOf(t);
            }

            public String toString() {
                return "TO_RANGE";
            }
        };

        @NotNull
        public abstract IElementType typeOf(@NotNull T var1);

        @NotNull
        public abstract TextRange rangeOf(@NotNull T var1);

        @NotNull
        public abstract CharSequence textOf(@NotNull T var1);

        @Nullable
        public abstract T parent(@NotNull T var1);

        @NotNull
        public abstract JBIterable<? extends T> children(@NotNull T var1);

        public JBIterable<? extends T> fun(T t) {
            return this.children(t);
        }

        @NotNull
        public JBIterable<T> parents(@Nullable T element) {
            return JBIterable.generate(element, t -> this.parent(t));
        }
    }
}

