/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DependencyValidationManager
extends NamedScopesHolder {
    @NotNull
    public static DependencyValidationManager getInstance(@NotNull Project project) {
        return ServiceManager.getService(project, DependencyValidationManager.class);
    }

    public DependencyValidationManager(@NotNull Project project) {
        super(project);
    }

    public abstract boolean hasRules();

    @Nullable
    public abstract DependencyRule getViolatorDependencyRule(@NotNull PsiFile var1, @NotNull PsiFile var2);

    public abstract DependencyRule @NotNull [] getViolatorDependencyRules(@NotNull PsiFile var1, @NotNull PsiFile var2);

    public abstract DependencyRule @NotNull [] getApplicableRules(@NotNull PsiFile var1);

    public abstract DependencyRule @NotNull [] getAllRules();

    public abstract void removeAllRules();

    public abstract void addRule(@NotNull DependencyRule var1);

    public abstract boolean skipImportStatements();

    public abstract void setSkipImportStatements(boolean var1);

    @NotNull
    public abstract Map<String, PackageSet> getUnnamedScopes();
}

