/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowEP
implements PluginAware {
    private static final Logger LOG = Logger.getInstance(ToolWindowEP.class);
    public static final ExtensionPointName<ToolWindowEP> EP_NAME = new ExtensionPointName("com.intellij.toolWindow");
    private PluginDescriptor pluginDescriptor;
    @Attribute
    public String id;
    @Attribute
    public String anchor;
    @Attribute
    @Deprecated
    public boolean side;
    @Attribute(value="icon")
    public String icon;
    @Attribute(value="doNotActivateOnStart")
    public boolean isDoNotActivateOnStart;
    @Attribute
    public String factoryClass;
    @Attribute
    @Deprecated
    public String conditionClass;
    @Attribute
    public boolean secondary;
    @Attribute
    public boolean canCloseContents;
    private Class<? extends ToolWindowFactory> myFactoryClass;
    private volatile ToolWindowFactory myFactory;

    @Transient
    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public final void setPluginDescriptor(@NotNull PluginDescriptor value) {
        this.pluginDescriptor = value;
    }

    @Deprecated
    @Nullable
    public ToolWindowFactory getToolWindowFactory() {
        return this.getToolWindowFactory(this.getPluginDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ToolWindowFactory getToolWindowFactory(@NotNull PluginDescriptor pluginDescriptor) {
        ToolWindowFactory factory = this.myFactory;
        if (factory != null) {
            return factory;
        }
        if (this.factoryClass == null) {
            LOG.error((Throwable)new PluginException("No toolwindow factory specified for " + this.id, pluginDescriptor.getPluginId()));
            return null;
        }
        ToolWindowEP toolWindowEP = this;
        synchronized (toolWindowEP) {
            factory = this.myFactory;
            if (factory != null) {
                return factory;
            }
            try {
                this.myFactory = factory = (ToolWindowFactory)ApplicationManager.getApplication().instantiateExtensionWithPicoContainerOnlyIfNeeded(this.factoryClass, pluginDescriptor);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        return factory;
    }

    @Nullable
    public Class<? extends ToolWindowFactory> getFactoryClass(@NotNull PluginDescriptor pluginDescriptor) {
        if (this.myFactoryClass == null) {
            if (this.factoryClass == null) {
                LOG.error((Throwable)new PluginException("No toolwindow factory specified for " + this.id, pluginDescriptor.getPluginId()));
                return null;
            }
            ClassLoader classLoader = pluginDescriptor.getPluginClassLoader();
            try {
                this.myFactoryClass = Class.forName(this.factoryClass, true, classLoader == null ? ToolWindowEP.class.getClassLoader() : classLoader);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return this.myFactoryClass;
    }

    @Deprecated
    @Nullable
    public Condition<Project> getCondition() {
        return this.getCondition(this.getPluginDescriptor());
    }

    @Nullable
    public Condition<Project> getCondition(@NotNull PluginDescriptor pluginDescriptor) {
        if (this.conditionClass == null) {
            return null;
        }
        try {
            return (Condition)ApplicationManager.getApplication().instantiateExtensionWithPicoContainerOnlyIfNeeded(this.conditionClass, pluginDescriptor);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.id;
    }
}

