/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StatusBarWidget
extends Disposable {
    @NonNls
    @NotNull
    public String ID();

    @Nullable
    default public WidgetPresentation getPresentation() {
        return this.getPresentation(SystemInfo.isMac ? PlatformType.MAC : PlatformType.DEFAULT);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @Nullable
    default public WidgetPresentation getPresentation(@NotNull PlatformType type) {
        return null;
    }

    public void install(@NotNull StatusBar var1);

    public static abstract class WidgetBorder
    implements Border {
        public static final Border ICON = JBUI.Borders.empty((int)0, (int)4);
        public static final Border INSTANCE = JBUI.Borders.empty((int)0, (int)6);
        public static final Border WIDE = JBUI.Borders.empty((int)0, (int)6);
    }

    public static interface MultipleTextValuesPresentation
    extends WidgetPresentation {
        @Nullable(value="null means the widget is unable to show the popup")
        public @Nullable(value="null means the widget is unable to show the popup") ListPopup getPopupStep();

        @Nullable
        public String getSelectedValue();

        @Deprecated
        @NotNull
        @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
        default public String getMaxValue() {
            return "";
        }

        @Nullable
        default public Icon getIcon() {
            return null;
        }
    }

    public static interface TextPresentation
    extends WidgetPresentation {
        @NotNull
        public @NlsContexts.Label String getText();

        @Deprecated
        @NotNull
        @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
        default public String getMaxPossibleText() {
            return "";
        }

        public float getAlignment();
    }

    public static interface IconPresentation
    extends WidgetPresentation {
        @Nullable
        public Icon getIcon();
    }

    public static interface WidgetPresentation {
        @Nullable
        public @NlsContexts.Tooltip String getTooltipText();

        @Nullable
        default public String getShortcutText() {
            return null;
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer();
    }

    public static interface Multiframe
    extends StatusBarWidget {
        public StatusBarWidget copy();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static enum PlatformType {
        DEFAULT,
        MAC;

    }
}

