/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;

public final class IdeGlassPaneUtil {
    private IdeGlassPaneUtil() {
    }

    @NotNull
    public static IdeGlassPane find(@NotNull Component component) {
        if (!(component instanceof JComponent)) {
            throw new IllegalArgumentException("Component must be instance of JComponent");
        }
        JRootPane root = ((JComponent)component).getRootPane();
        if (root == null) {
            throw new IllegalArgumentException("Component must be visible in order to find glass pane for it");
        }
        Component gp = root.getGlassPane();
        if (!(gp instanceof IdeGlassPane)) {
            throw new IllegalArgumentException("Glass pane should be " + IdeGlassPane.class.getName());
        }
        return (IdeGlassPane)((Object)gp);
    }

    public static void installPainter(final @NotNull JComponent target, final @NotNull Painter painter, final @NotNull Disposable parent) {
        UiNotifyConnector connector = new UiNotifyConnector(target, new Activatable(){
            private IdeGlassPane myPane;
            private Disposable myPanePainterListeners = Disposer.newDisposable();

            @Override
            public void showNotify() {
                IdeGlassPane pane = IdeGlassPaneUtil.find(target);
                if (this.myPane != null && this.myPane != pane) {
                    Disposer.dispose((Disposable)this.myPanePainterListeners);
                }
                this.myPane = pane;
                this.myPanePainterListeners = Disposer.newDisposable((String)"PanePainterListeners");
                Disposer.register((Disposable)parent, (Disposable)this.myPanePainterListeners);
                this.myPane.addPainter(target, painter, this.myPanePainterListeners);
            }

            @Override
            public void hideNotify() {
                Disposer.dispose((Disposable)this.myPanePainterListeners);
            }
        });
        Disposer.register((Disposable)parent, (Disposable)connector);
    }

    public static boolean canBePreprocessed(@NotNull MouseEvent e) {
        Component c = UIUtil.getDeepestComponentAt((Component)e.getComponent(), (int)e.getX(), (int)e.getY());
        if (JBPopupFactory.getInstance().getParentBalloonFor(c) != null && e.getID() != 506) {
            return false;
        }
        if (c instanceof IdeGlassPane.TopComponent) {
            return ((IdeGlassPane.TopComponent)((Object)c)).canBePreprocessed(e);
        }
        return true;
    }
}

