/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.LocalTimeCounter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class VFileContentChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;
    private final long myOldTimestamp;
    private final long myNewTimestamp;
    private final long myOldLength;
    private final long myNewLength;
    private static final int UNDEFINED_TIMESTAMP_OR_LENGTH = -1;

    public VFileContentChangeEvent(Object requestor, @NotNull VirtualFile file, long oldModificationStamp, long newModificationStamp, boolean isFromRefresh) {
        this(requestor, file, oldModificationStamp, newModificationStamp, -1L, -1L, -1L, -1L, isFromRefresh);
    }

    public VFileContentChangeEvent(Object requestor, @NotNull VirtualFile file, long oldModificationStamp, long newModificationStamp, long oldTimestamp, long newTimestamp, long oldLength, long newLength, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myFile = file;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp == -1L ? LocalTimeCounter.currentTime() : newModificationStamp;
        this.myOldTimestamp = oldTimestamp;
        this.myNewTimestamp = newTimestamp;
        this.myOldLength = oldLength;
        this.myNewLength = newLength;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public long getModificationStamp() {
        return this.myNewModificationStamp;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    public long getOldTimestamp() {
        return this.myOldTimestamp;
    }

    public long getNewTimestamp() {
        return this.myNewTimestamp;
    }

    public long getOldLength() {
        return this.myOldLength;
    }

    public long getNewLength() {
        return this.myNewLength;
    }

    public boolean isLengthAndTimestampDiffProvided() {
        return this.myOldTimestamp != -1L || this.myNewTimestamp != -1L || this.myOldLength != -1L || this.myNewLength != -1L;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[update: " + this.myFile.getUrl() + (this.myOldTimestamp != this.myNewTimestamp ? ", oldTimestamp:" + this.myOldTimestamp + ", newTimestamp:" + this.myNewTimestamp : "") + (this.myOldLength != this.myNewLength ? ", oldLength:" + this.myOldLength + ", newLength:" + this.myNewLength : "") + "]";
    }

    @Override
    @NotNull
    protected String computePath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myFile.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && this.myFile.getModificationStamp() == this.myOldModificationStamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileContentChangeEvent event = (VFileContentChangeEvent)o;
        if (this.myNewModificationStamp != event.myNewModificationStamp) {
            return false;
        }
        if (this.myOldModificationStamp != event.myOldModificationStamp) {
            return false;
        }
        return this.myFile.equals(event.myFile);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + (int)(this.myOldModificationStamp ^ this.myOldModificationStamp >>> 32);
        result = 31 * result + (int)(this.myNewModificationStamp ^ this.myNewModificationStamp >>> 32);
        return result;
    }
}

