/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BulkVirtualFileListenerAdapter
implements BulkFileListener {
    private final VirtualFileListener myAdapted;
    private final VirtualFileSystem myFileSystem;

    public BulkVirtualFileListenerAdapter(@NotNull VirtualFileListener adapted) {
        this(adapted, null);
    }

    public BulkVirtualFileListenerAdapter(@NotNull VirtualFileListener adapted, @Nullable VirtualFileSystem fileSystem) {
        this.myAdapted = adapted;
        this.myFileSystem = fileSystem;
    }

    @Override
    public void before(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            if (this.myFileSystem != null && this.myFileSystem != vFileEvent.getFileSystem()) continue;
            BulkVirtualFileListenerAdapter.fireBefore(this.myAdapted, vFileEvent);
        }
    }

    @Override
    public void after(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            if (this.myFileSystem != null && this.myFileSystem != vFileEvent.getFileSystem()) continue;
            BulkVirtualFileListenerAdapter.fireAfter(this.myAdapted, vFileEvent);
        }
    }

    public static void fireAfter(@NotNull VirtualFileListener adapted, @NotNull VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file = ce.getFile();
            adapted.contentsChanged(new VirtualFileEvent(event.getRequestor(), file, file.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileCopyEvent) {
            VFileCopyEvent ce = (VFileCopyEvent)event;
            VirtualFile original = ce.getFile();
            VirtualFile copy = ce.getNewParent().findChild(ce.getNewChildName());
            if (copy != null) {
                adapted.fileCopied(new VirtualFileCopyEvent(event.getRequestor(), original, copy));
            }
        } else if (event instanceof VFileCreateEvent) {
            VFileCreateEvent ce = (VFileCreateEvent)event;
            VirtualFile newChild = ce.getFile();
            if (newChild != null) {
                adapted.fileCreated(new VirtualFileEvent(event.getRequestor(), newChild, ce.getParent(), 0L, 0L));
            }
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            adapted.fileDeleted(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            adapted.fileMoved(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            adapted.propertyChanged(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }

    public static void fireBefore(@NotNull VirtualFileListener adapted, @NotNull VFileEvent event) {
        if (event instanceof VFileContentChangeEvent) {
            VFileContentChangeEvent ce = (VFileContentChangeEvent)event;
            VirtualFile file = ce.getFile();
            adapted.beforeContentsChange(new VirtualFileEvent(event.getRequestor(), file, file.getParent(), ce.getOldModificationStamp(), ce.getModificationStamp()));
        } else if (event instanceof VFileDeleteEvent) {
            VFileDeleteEvent de = (VFileDeleteEvent)event;
            adapted.beforeFileDeletion(new VirtualFileEvent(event.getRequestor(), de.getFile(), de.getFile().getParent(), 0L, 0L));
        } else if (event instanceof VFileMoveEvent) {
            VFileMoveEvent me = (VFileMoveEvent)event;
            adapted.beforeFileMovement(new VirtualFileMoveEvent(event.getRequestor(), me.getFile(), me.getOldParent(), me.getNewParent()));
        } else if (event instanceof VFilePropertyChangeEvent) {
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)event;
            adapted.beforePropertyChange(new VirtualFilePropertyEvent(event.getRequestor(), pce.getFile(), pce.getPropertyName(), pce.getOldValue(), pce.getNewValue()));
        }
    }
}

