/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class FilterDescendantVirtualFileConvertible<T>
extends AbstractFilterChildren<T> {
    @NotNull
    private final Comparator<? super T> myComparator;
    @NotNull
    private final Function<? super T, ? extends VirtualFile> myConvertor;

    public FilterDescendantVirtualFileConvertible(@NotNull Function<? super T, ? extends VirtualFile> convertor, @NotNull Comparator<? super VirtualFile> comparator) {
        this.myConvertor = convertor;
        this.myComparator = Comparator.comparing(this.myConvertor, comparator);
    }

    @Override
    protected void sortAscending(@NotNull List<? extends T> ts) {
        ts.sort(this.myComparator);
    }

    @Override
    protected boolean isAncestor(T parent, T child) {
        return VfsUtil.isAncestor(this.myConvertor.apply(parent), this.myConvertor.apply(child), false);
    }
}

