/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentFactory;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkCommandLineSetup;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.util.Map;
import java.util.jar.Attributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdkUtil {
    public static final Key<Map<String, String>> COMMAND_LINE_CONTENT = Key.create((String)"command.line.content");
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, @NotNull Attributes.Name attribute) {
        File signatureJar;
        String homePath;
        String versionString;
        if (attribute == Attributes.Name.IMPLEMENTATION_VERSION && (versionString = jdk.getVersionString()) != null) {
            int start = versionString.indexOf(34);
            int end = versionString.lastIndexOf(34);
            if (start >= 0 && end > start) {
                return versionString.substring(start + 1, end);
            }
        }
        if ((homePath = jdk.getHomePath()) != null && (signatureJar = FileUtil.findFirstThatExist((String[])new String[]{homePath + "/jre/lib/rt.jar", homePath + "/lib/rt.jar", homePath + "/lib/jrt-fs.jar", homePath + "/jre/lib/vm.jar", homePath + "/../Classes/classes.jar"})) != null) {
            return JarUtil.getJarAttribute((File)signatureJar, (Attributes.Name)attribute);
        }
        return null;
    }

    @Nullable
    public static String suggestJdkName(@Nullable String versionString) {
        JavaVersion version = JavaVersion.tryParse((String)versionString);
        if (version == null) {
            return null;
        }
        StringBuilder suggested = new StringBuilder();
        if (version.feature < 9) {
            suggested.append("1.");
        }
        suggested.append(version.feature);
        if (version.ea) {
            suggested.append("-ea");
        }
        return suggested.toString();
    }

    public static boolean checkForJdk(@NotNull String homePath) {
        return JdkUtil.checkForJdk(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJdk(@NotNull File homePath) {
        return (new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile()) && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForJre(@NotNull String homePath) {
        return JdkUtil.checkForJre(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJre(@NotNull File homePath) {
        return new File(homePath, "bin/java").isFile() || new File(homePath, "bin/java.exe").isFile();
    }

    public static boolean checkForRuntime(@NotNull String homePath) {
        return new File(homePath, "jre/lib/rt.jar").exists() || new File(homePath, "lib/rt.jar").exists() || JdkUtil.isModularRuntime(homePath) || new File(homePath, "../Classes/classes.jar").exists() || new File(homePath, "jre/lib/vm.jar").exists() || new File(homePath, "classes").isDirectory();
    }

    public static boolean isModularRuntime(@NotNull String homePath) {
        return JdkUtil.isModularRuntime(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean isModularRuntime(@NotNull File homePath) {
        return new File(homePath, "lib/jrt-fs.jar").isFile() || JdkUtil.isExplodedModularRuntime(homePath.getPath());
    }

    public static boolean isExplodedModularRuntime(@NotNull String homePath) {
        return new File(homePath, "modules/java.base").isDirectory();
    }

    @ApiStatus.Internal
    @NotNull
    public static TargetedCommandLineBuilder setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters, @NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration targetConfiguration) throws CantRunException {
        JdkCommandLineSetup setup = new JdkCommandLineSetup(request, targetConfiguration);
        setup.setupJavaExePath(javaParameters);
        setup.setupCommandLine(javaParameters);
        return setup.getCommandLine();
    }

    @NotNull
    public static GeneralCommandLine setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        LocalTargetEnvironmentFactory environmentFactory = new LocalTargetEnvironmentFactory();
        TargetEnvironmentRequest request = environmentFactory.createRequest();
        return environmentFactory.prepareRemoteEnvironment(request, new EmptyProgressIndicator()).createGeneralCommandLine(JdkUtil.setupJVMCommandLine(javaParameters, request, null).build());
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance(project).getBoolean("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.vmoptions", true);
    }

    public static boolean useDynamicParameters() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.parameters", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        try {
            javaParameters.setUseDynamicClasspath(forceDynamicClasspath);
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{exePath});
            JdkUtil.setupCommandLine(commandLine, javaParameters);
            return commandLine;
        }
        catch (CantRunException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private static void setupCommandLine(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters) throws CantRunException {
        LocalTargetEnvironmentFactory environmentFactory = new LocalTargetEnvironmentFactory();
        TargetEnvironmentRequest request = environmentFactory.createRequest();
        JdkCommandLineSetup setup = new JdkCommandLineSetup(request, null);
        setup.setupCommandLine(javaParameters);
        LocalTargetEnvironment environment = environmentFactory.prepareRemoteEnvironment(request, new EmptyProgressIndicator());
        GeneralCommandLine generalCommandLine = environment.createGeneralCommandLine(setup.getCommandLine().build());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.getParametersList().addAll(generalCommandLine.getParametersList().getList());
        commandLine.getEnvironment().putAll(generalCommandLine.getEnvironment());
    }
}

