/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.text.StringKt;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u0007\u001a\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006\u001a2\u0010\u000f\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u001c\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\b\u001a\u000e\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001d\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020!0#H\u0086\b\u001a\u0016\u0010$\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020&\u001a:\u0010$\u001a\u00020!2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2#\b\u0004\u0010%\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020!0#H\u0086\b\u001a\"\u0010$\u001a\u00020!2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0)H\u0007\u001a\n\u0010*\u001a\u00020+*\u00020\n\u001a*\u0010\u000f\u001a\u00020\u0006*\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u0006H\u0007\u001a(\u0010,\u001a\u00020+*\u00020\n2\u0006\u0010-\u001a\u00020+2\b\b\u0002\u0010.\u001a\u00020\f2\b\b\u0002\u0010\u0014\u001a\u00020\u0006H\u0007\u001a(\u0010,\u001a\u00020+*\u00020\n2\u0006\u0010/\u001a\u00020\u00062\b\b\u0002\u0010\u0013\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\u0006H\u0007\u001a\f\u00100\u001a\u0004\u0018\u00010\b*\u00020\u0002\u001a\f\u00101\u001a\u0004\u0018\u00010\b*\u00020\n\u001a3\u00102\u001a\u0002H3\"\u0004\b\u0000\u00103*\u00020\n2\u0019\b\u0004\u00104\u001a\u0013\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002H30#\u00a2\u0006\u0002\b6H\u0086\b\u00a2\u0006\u0002\u00107\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00068"}, d2={"rootManager", "Lcom/intellij/openapi/roots/ModuleRootManager;", "Lcom/intellij/openapi/module/Module;", "getRootManager", "(Lcom/intellij/openapi/module/Module;)Lcom/intellij/openapi/roots/ModuleRootManager;", "calcRelativeToProjectPath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "includeFilePath", "", "includeUniqueFilePath", "keepModuleAlwaysOnTheLeft", "getProjectCacheFileName", "projectPath", "presentableUrl", "projectName", "isForceNameUse", "hashSeparator", "extensionWithDot", "guessCurrentProject", "component", "Ljavax/swing/JComponent;", "guessProjectForContentFile", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "guessProjectForFile", "isProjectDirectoryExistsUsingIo", "parent", "isProjectOrWorkspaceFile", "processOpenedProjects", "", "processor", "Lkotlin/Function1;", "runWhenProjectOpened", "handler", "Ljava/lang/Runnable;", "Lkotlin/ParameterName;", "name", "Ljava/util/function/Consumer;", "getExternalConfigurationDir", "Ljava/nio/file/Path;", "getProjectCachePath", "baseDir", "forceNameUse", "cacheDirName", "guessModuleDir", "guessProjectDir", "modifyModules", "T", "task", "Lcom/intellij/openapi/module/ModifiableModuleModel;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.ide"})
@JvmName(name="ProjectUtil")
public final class ProjectUtil {
    @NotNull
    public static final ModuleRootManager getRootManager(@NotNull Module $this$rootManager) {
        return ModuleRootManager.getInstance($this$rootManager);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath, boolean keepModuleAlwaysOnTheLeft) {
        if (file instanceof VirtualFilePathWrapper && ((VirtualFilePathWrapper)((Object)file)).enforcePresentableName()) {
            return includeFilePath ? ((VirtualFilePathWrapper)((Object)file)).getPresentablePath() : file.getName();
        }
        String url = includeFilePath ? file.getPresentableUrl() : (includeUniqueFilePath && project != null ? UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file) : file.getName());
        return project == null ? url : ProjectUtilCore.displayUrlRelativeToProject(file, url, project, includeFilePath, keepModuleAlwaysOnTheLeft);
    }

    public static /* synthetic */ String calcRelativeToProjectPath$default(VirtualFile virtualFile2, Project project, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return ProjectUtil.calcRelativeToProjectPath(virtualFile2, project, bl, bl2, bl3);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath, boolean includeUniqueFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, includeUniqueFilePath, false, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project, boolean includeFilePath) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, includeFilePath, false, false, 24, null);
    }

    @JvmOverloads
    @NotNull
    public static final String calcRelativeToProjectPath(@NotNull VirtualFile file, @Nullable Project project) {
        return ProjectUtil.calcRelativeToProjectPath$default(file, project, false, false, false, 28, null);
    }

    @Nullable
    public static final Project guessProjectForFile(@Nullable VirtualFile file) {
        return ProjectLocator.getInstance().guessProjectForFile(file);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file, @NotNull FileType fileType) {
        Project project;
        Object v1;
        List list;
        block4: {
            void $this$filterTo$iv$iv;
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file, fileType)) {
                return null;
            }
            Project[] $this$filter$iv = ProjectManager.getInstance().getOpenProjects();
            boolean $i$f$filter = false;
            Project[] projectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_8 = $this$filterTo$iv$iv;
            int n = ((void)var8_8).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var8_8[i];
                boolean bl = false;
                if (!(!it.isDefault() && it.isInitialized() && !it.isDisposed() && ProjectRootManager.getInstance((Project)it).getFileIndex().isInContent(file))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                JFrame jFrame = WindowManager.getInstance().getFrame(it);
                if (!(jFrame != null ? jFrame.isActive() : false)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        if ((project = (Project)v1) == null) {
            project = (Project)CollectionsKt.firstOrNull((List)list);
        }
        return project;
    }

    public static /* synthetic */ Project guessProjectForContentFile$default(VirtualFile virtualFile2, FileType fileType, int n, Object object) {
        if ((n & 2) != 0) {
            fileType = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence());
        }
        return ProjectUtil.guessProjectForContentFile(virtualFile2, fileType);
    }

    @JvmOverloads
    @Nullable
    public static final Project guessProjectForContentFile(@NotNull VirtualFile file) {
        return ProjectUtil.guessProjectForContentFile$default(file, null, 2, null);
    }

    public static final boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file);
    }

    @NotNull
    public static final Project guessCurrentProject(@Nullable JComponent component) {
        Project project;
        Project project2;
        Project project3;
        Project project4 = null;
        if (component != null) {
            project4 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(component));
        }
        if ((project3 = project4) == null) {
            project3 = project2 = (Project)ArraysKt.firstOrNull((Object[])ProjectManager.getInstance().getOpenProjects());
        }
        if (project3 == null) {
            project2 = project = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        }
        if (project2 == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        return project;
    }

    public static final <T> T modifyModules(@NotNull Project $this$modifyModules, @NotNull Function1<? super ModifiableModuleModel, ? extends T> task) {
        int $i$f$modifyModules = 0;
        ModifiableModuleModel model = ModuleManager.getInstance($this$modifyModules).getModifiableModel();
        Object result = task.invoke((Object)model);
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(model){
            final /* synthetic */ ModifiableModuleModel $model$inlined;
            {
                this.$model$inlined = modifiableModuleModel;
            }

            public final T compute() {
                boolean bl = false;
                this.$model$inlined.commit();
                return (T)Unit.INSTANCE;
            }
        });
        return (T)result;
    }

    public static final boolean isProjectDirectoryExistsUsingIo(@NotNull VirtualFile parent) {
        boolean bl;
        try {
            bl = PathKt.exists((Path)Paths.get(FileUtil.toSystemDependentName((String)parent.getPath()), ".idea"));
        }
        catch (InvalidPathException e) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final VirtualFile guessProjectDir(@NotNull Project $this$guessProjectDir) {
        Module module;
        Object object;
        Object object2;
        block6: {
            if ($this$guessProjectDir.isDefault()) {
                return null;
            }
            Object[] modules = ModuleManager.getInstance($this$guessProjectDir).getModules();
            if (modules.length == 1) {
                object2 = (Module)ArraysKt.first((Object[])modules);
            } else {
                Object[] $this$firstOrNull$iv = modules;
                boolean $i$f$firstOrNull = false;
                Object[] objectArray = $this$firstOrNull$iv;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    Object it = element$iv = objectArray[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$guessProjectDir.getName())) continue;
                    object2 = element$iv;
                    break block6;
                }
                object2 = null;
            }
        }
        if ((object = (module = object2)) != null && (object = ProjectUtil.guessModuleDir((Module)object)) != null) {
            Object object3 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object3;
            boolean bl3 = false;
            return it;
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String string = $this$guessProjectDir.getBasePath();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return localFileSystem.findFileByPath(string);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile guessModuleDir(@NotNull Module $this$guessModuleDir) {
        VirtualFile virtualFile2;
        Object v0;
        List contentRoots;
        block3: {
            void $this$filterTo$iv$iv;
            VirtualFile[] $this$filter$iv = ProjectUtil.getRootManager($this$guessModuleDir).getContentRoots();
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Object t = $this$filterTo$iv$iv;
            int n = ((void)t).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = t[i];
                boolean bl = false;
                if (!it.isDirectory()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            contentRoots = (List)destination$iv$iv;
            Iterable iterable = contentRoots;
            boolean bl = false;
            object = iterable;
            boolean bl2 = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                t = iterator.next();
                VirtualFile it = (VirtualFile)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$guessModuleDir.getName())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((virtualFile2 = (VirtualFile)v0) == null) {
            virtualFile2 = (VirtualFile)CollectionsKt.firstOrNull((List)contentRoots);
        }
        return virtualFile2;
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName, boolean isForceNameUse, @NotNull String hashSeparator, @NotNull String extensionWithDot) {
        return ProjectUtil.getProjectCacheFileName($this$getProjectCacheFileName.getPresentableUrl(), $this$getProjectCacheFileName.getName(), isForceNameUse, hashSeparator, extensionWithDot);
    }

    public static /* synthetic */ String getProjectCacheFileName$default(Project project, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = ".";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        return ProjectUtil.getProjectCacheFileName(project, bl, string, string2);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName, boolean isForceNameUse, @NotNull String hashSeparator) {
        return ProjectUtil.getProjectCacheFileName$default($this$getProjectCacheFileName, isForceNameUse, hashSeparator, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName, boolean isForceNameUse) {
        return ProjectUtil.getProjectCacheFileName$default($this$getProjectCacheFileName, isForceNameUse, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getProjectCacheFileName(@NotNull Project $this$getProjectCacheFileName) {
        return ProjectUtil.getProjectCacheFileName$default($this$getProjectCacheFileName, false, null, null, 7, null);
    }

    @NotNull
    public static final String getProjectCacheFileName(@NotNull String projectPath) {
        return ProjectUtil.getProjectCacheFileName(projectPath, PathUtil.getFileName(projectPath), false, ".", "");
    }

    private static final String getProjectCacheFileName(String presentableUrl, String projectName, boolean isForceNameUse, String hashSeparator, String extensionWithDot) {
        String string;
        if (isForceNameUse || presentableUrl == null) {
            string = projectName;
        } else {
            String string2 = PathUtilRt.getFileName((String)presentableUrl);
            Locale locale = Locale.US;
            boolean bl = false;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = StringsKt.removeSuffix((String)string5, (CharSequence)".ipr");
        }
        String name = string;
        name = PathKt.sanitizeFileName$default((String)name, null, (boolean)false, (int)2, null);
        String string6 = presentableUrl;
        if (string6 == null) {
            string6 = name;
        }
        String locationHash = Integer.toHexString(string6.hashCode());
        name = StringKt.trimMiddle(name, RangesKt.coerceAtMost((int)name.length(), (int)(255 - hashSeparator.length() - locationHash.length())), false);
        return name + hashSeparator + locationHash + extensionWithDot;
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull String cacheDirName, boolean isForceNameUse, @NotNull String extensionWithDot) {
        return PathManagerEx.getAppSystemDir().resolve(cacheDirName).resolve(ProjectUtil.getProjectCacheFileName$default($this$getProjectCachePath, isForceNameUse, null, extensionWithDot, 2, null));
    }

    public static /* synthetic */ Path getProjectCachePath$default(Project project, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        return ProjectUtil.getProjectCachePath(project, string, bl, string2);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull String cacheDirName, boolean isForceNameUse) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, cacheDirName, isForceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull String cacheDirName) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, cacheDirName, false, null, 6, null);
    }

    @NotNull
    public static final Path getExternalConfigurationDir(@NotNull Project $this$getExternalConfigurationDir) {
        return ProjectUtil.getProjectCachePath$default($this$getExternalConfigurationDir, "external_build_system", false, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull Path baseDir, boolean forceNameUse, @NotNull String hashSeparator) {
        return baseDir.resolve(ProjectUtil.getProjectCacheFileName$default($this$getProjectCachePath, forceNameUse, hashSeparator, null, 4, null));
    }

    public static /* synthetic */ Path getProjectCachePath$default(Project project, Path path2, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = ".";
        }
        return ProjectUtil.getProjectCachePath(project, path2, bl, string);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull Path baseDir, boolean forceNameUse) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, baseDir, forceNameUse, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final Path getProjectCachePath(@NotNull Project $this$getProjectCachePath, @NotNull Path baseDir) {
        return ProjectUtil.getProjectCachePath$default($this$getProjectCachePath, baseDir, false, null, 6, null);
    }

    public static final void runWhenProjectOpened(@NotNull Project project, @NotNull Runnable handler) {
        boolean $i$f$runWhenProjectOpened = false;
        Project project2 = project;
        SimpleMessageBusConnection connection$iv = (project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().simpleConnect();
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleMessageBusConnection $connection;
            final /* synthetic */ Runnable $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = runnable;
            }

            public void projectOpened(@NotNull Project eventProject) {
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    boolean bl = false;
                    this.$handler$inlined.run();
                }
            }
        });
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Consumer<Project> handler) {
        boolean $i$f$runWhenProjectOpened = false;
        Project project2 = project;
        SimpleMessageBusConnection connection$iv = (project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().simpleConnect();
        connection$iv.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection$iv, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleMessageBusConnection $connection;
            final /* synthetic */ Consumer $handler$inlined;
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler$inlined = consumer;
            }

            public void projectOpened(@NotNull Project eventProject) {
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    Project it = eventProject;
                    boolean bl = false;
                    this.$handler$inlined.accept(it);
                }
            }
        });
    }

    public static /* synthetic */ void runWhenProjectOpened$default(Project project, Consumer consumer, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        ProjectUtil.runWhenProjectOpened(project, consumer);
    }

    @JvmOverloads
    public static final void runWhenProjectOpened(@NotNull Consumer<Project> handler) {
        ProjectUtil.runWhenProjectOpened$default(null, handler, 1, null);
    }

    public static final void runWhenProjectOpened(@Nullable Project project, @NotNull Function1<? super Project, Unit> handler) {
        int $i$f$runWhenProjectOpened = 0;
        Project project2 = project;
        SimpleMessageBusConnection connection = (project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().simpleConnect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(project, connection, handler){
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleMessageBusConnection $connection;
            final /* synthetic */ Function1 $handler;

            public void projectOpened(@NotNull Project eventProject) {
                if (this.$project == null || this.$project == eventProject) {
                    this.$connection.disconnect();
                    this.$handler.invoke((Object)eventProject);
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$connection = $captured_local_variable$1;
                this.$handler = $captured_local_variable$2;
            }
        });
    }

    public static /* synthetic */ void runWhenProjectOpened$default(Project project, Function1 handler, int n, Object object) {
        if ((n & 1) != 0) {
            project = null;
        }
        boolean $i$f$runWhenProjectOpened = false;
        Project project2 = project;
        SimpleMessageBusConnection connection = (project2 != null ? (ComponentManager)project2 : (ComponentManager)ApplicationManager.getApplication()).getMessageBus().simpleConnect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new /* invalid duplicate definition of identical inner class */);
    }

    public static final void processOpenedProjects(@NotNull Function1<? super Project, Unit> processor) {
        int $i$f$processOpenedProjects = 0;
        Project[] projectArray = ProjectManager.getInstanceIfCreated();
        if (projectArray == null || (projectArray = projectArray.getOpenProjects()) == null) {
            return;
        }
        for (Project project : projectArray) {
            if (project.isDisposed() || !project.isInitialized()) continue;
            processor.invoke((Object)project);
        }
    }
}

